package integer;


import java.awt.Color;
import java.awt.Font;
import net.useobjects.AbstractGroup;
import net.useobjects.Rectangle;
import net.useobjects.Text;

//Trieda zobrazuje ciselnu hodnotu. Hodnota je dana modelom
public class Label extends AbstractGroup {
    private Text text;

    public Label(BoundedIntegerModel model, AbstractGroup parentGroup, int positionX, int positionY) {
        super(parentGroup, positionX, positionY);
        
        new Rectangle(this, 0, 0, 40, 20, 0, Color.BLACK, false);
        
        //na zaciatku zistime hodnotu z modelu volanim model.getValue()
        text = new Text(this, intToString(model.getValue()), -15, 4, 0, new Font(Font.MONOSPACED, Font.PLAIN, 12)); 
        
        model.addBoundedIntegerListener(new IntegerObserver());
    }
    
    //metoda urcujuca format vypisu
    private String intToString(int integer) {
        return String.format("%4d", integer);
        //return Integer.toString(integer);
        //return Integer.toString(integer,16); 
    }
    
    private class IntegerObserver implements BoundedIntegerListener {

        @Override
        public void integerChanged(BoundedIntegerEvent event) {
            text.setText(intToString(event.getValue()));
        }
    }
}
