package integer;


import java.util.ArrayList;
import java.util.List;

//Trieda reprezentuje ciselnu hodnotu v zadanom intervale
public class BoundedIntegerModel implements BoundedIntegerEventSource {
    private int value; //aktualna ciselna hodnota
    private final int MIN; //dolna hranica
    private final int MAX; //horna hranica
    
    private List<BoundedIntegerListener> listeners;

    public BoundedIntegerModel(int value, int min, int max) {
        assert( min < max && value >= min && value <= max) : "chybne zadane parametre pre konstruktor BoundedIntegerModel (" + value + ", " + min + ", " + max + ")";
        
        this.value = value;
        this.MIN = min;
        this.MAX = max;
        
        listeners = new ArrayList<BoundedIntegerListener>();
    }
    
    public int getMax() {
        return MAX;
    }

    public int getMin() {
        return MIN;
    }

    public int getValue() {
        return value;
    }
    
    public int getRangeLength() {
        return MAX - MIN;
    }

    public void setValue(int newValue) {
        //upravime novu hodnotu tak, aby patrila do intervalu
        newValue = Math.max(newValue, MIN);
        newValue = Math.min(newValue, MAX);

        if( value != newValue) { //udalost generujeme iba ak sa meni hodnota
            value = newValue;
            notifyListeners();
        }
    }
    
    public void addBoundedIntegerListener(BoundedIntegerListener listener) {
        listeners.add(listener);
    }

    public void removeBoundedIntegerListener(BoundedIntegerListener listener) {
        listeners.remove(listener);
    }
    
    private void notifyListeners(){
        //instancie IntegerEvent su nemenne, ziadny listener nemoze zmenit stav instancie, 
        //preto staci vytvorit jednu instanciu a pouzit ju pri posielani udalosti vsetkym listenerom
        BoundedIntegerEvent event = new BoundedIntegerEvent(this, value, MIN, MAX); 
        for(BoundedIntegerListener listener: listeners) {
            listener.integerChanged(event);
        }
    }
}
