package color;


import integer.Slider;
import integer.BoundedIntegerListener;
import integer.BoundedIntegerEvent;
import java.awt.Color;
import net.useobjects.AbstractGroup;
import net.useobjects.Rectangle;

//Trieda reprezentuje trojicu slider-ov nastavujucich farebne zlozky farby
public class RgbSliders extends AbstractGroup {

    private Slider red;
    private Slider green;
    private Slider blue;
    private ColorModel model;

    public RgbSliders(ColorModel model, AbstractGroup parentGroup, double positionX, double positionY, double rotation) {
        super(parentGroup, positionX, positionY, rotation);
        this.model = model;

        new Rectangle(this, 0, 0, 290, 90, 0, new Color(240, 240, 240), true);

        final int MIN = model.getMinComponentValue();
        final int MAX = model.getMaxComponentValue();
        red   = new Slider(model.getRed(),   MIN, MAX, this, 0, -25, Color.RED);
        green = new Slider(model.getGreen(), MIN, MAX, this, 0,   0, Color.GREEN);
        blue  = new Slider(model.getBlue(),  MIN, MAX, this, 0,  25, Color.BLUE);

        model.addColorListener(new InnerColorListener());

        red.addBoundedIntegerListener(new RedController());
        green.addBoundedIntegerListener(new GreenController());
        blue.addBoundedIntegerListener(new BlueController());
    }

    //Ked model oznamy zmenu farby, zabezpeci posuv bezcov na slideroch
    private class InnerColorListener implements ColorListener {
        @Override
        public void colorChanged(ColorEvent event) {
            if (event.isRedChanged()) {
                red.setValue(event.getRed());
            }
            if (event.isGreenChanged()) {
                green.setValue(event.getGreen());
            }
            if (event.isBlueChanged()) {
                blue.setValue(event.getBlue());
            }
        }
    }

    //RedController (podla slidera bude riadit cervenu zlozku farby)
    private class RedController implements BoundedIntegerListener {
        @Override
        public void integerChanged(BoundedIntegerEvent event) {
            model.setRed(event.getValue()); 
        }
    }
    
    //GreeController (podla slidera bude riadit zelenu zlozku farby)
    private class GreenController implements BoundedIntegerListener {
        @Override
        public void integerChanged(BoundedIntegerEvent event) {
            model.setGreen(event.getValue()); 
        }
    }
    
    //BlueController (podla slidera bude riadit bodru zlozku farby)
    private class BlueController implements BoundedIntegerListener {
        @Override
        public void integerChanged(BoundedIntegerEvent event) {
            model.setBlue(event.getValue()); 
        }
    }
}
