package color;


import button.ButtonListener;
import button.ButtonEvent;
import button.Button;
import net.useobjects.AbstractGroup;

//Specializovane tlacidlo pre negaciu farby
public class NegateColorButton extends Button{
    private ColorModel model;
    
    public NegateColorButton(ColorModel model, AbstractGroup parentGroup, double positionX, double positionY) {
        super("negacia", parentGroup, positionX, positionY);
        this.model = model;
        
        this.addButtonListener(new NegateController());
    }
    
    private class NegateController implements ButtonListener{
        @Override
        public void clicked(ButtonEvent event) {
            final int MAX = model.getMaxComponentValue();
            int red   = MAX - model.getRed();
            int green = MAX - model.getGreen();
            int blue  = MAX - model.getBlue();
            
            model.setColor(red, green, blue);
        }
    }
}
