package color;

import net.useobjects.AbstractGroup;
import net.useobjects.Rectangle;


//Trieda zobrazuje panel, ktoreho farba je dana modelom
public class ColorPanel extends AbstractGroup {

    private Rectangle panel;

    public ColorPanel(ColorModel model, AbstractGroup parentGroup, double centerX, double centerY, double width, double height) {
        super(parentGroup, centerX, centerY);
        panel = new Rectangle(this, 0, 0, width, height, 0, model.getColor(), true);
        model.addColorListener(new InnerColorListener());
    }

    private class InnerColorListener implements ColorListener {
        @Override
        public void colorChanged(ColorEvent event) {
            panel.setColor(event.getColor());
        }
    }
}
