package color;

//Trieda ColorEvent nesie informacie o zmene farby
import java.awt.Color;

public class ColorEvent {
    private final ColorModel source;
    private final int red;
    private final int green;
    private final int blue;
    private final boolean redChanged;
    private final boolean greenChanged;
    private final boolean blueChanged;

    public ColorEvent(ColorModel source, int red, int green, int blue, boolean redChanged, boolean greenChanged, boolean blueChanged) {
        this.source = source;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.redChanged = redChanged;
        this.greenChanged = greenChanged;
        this.blueChanged = blueChanged;
    }

    public ColorModel getSource() {
        return source;
    }

    public int getRed() {
        return red;
    }

    public int getGreen() {
        return green;
    }

    public int getBlue() {
        return blue;
    }
    
    public Color getColor() {
        return new Color(red, green, blue);
    }
    
    public boolean isRedChanged() {
        return redChanged;
    }

    public boolean isGreenChanged() {
        return greenChanged;
    }
    
    public boolean isBlueChanged() {
        return blueChanged;
    }
}
