package button;


import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import net.useobjects.AbstractGroup;
import net.useobjects.Rectangle;
import net.useobjects.Text;
import net.useobjects.mouse.MouseAdapter;
import net.useobjects.mouse.MouseEvent;

//Trieda reprezentuje vseobecne tlacidlo
public class Button extends AbstractGroup {
    private List<ButtonListener> listeners; //zoznam prijimacov kliknutia

    //Vytvori tlacidlo ktore bude priradene do skupiny 'parentGroup' s textom 'text', na pozicii [positionX, positionY]
    public Button(String text, AbstractGroup parentGroup, double positionX, double positionY) {
        this(text, parentGroup, positionX, positionY, 100);
    }

    //Vytvori tlacidlo ktore bude priradene do skupiny 'parentGroup' s textom 'text', na pozicii [positionX, positionY], sirka 'width'
    public Button(String text, AbstractGroup parentGroup, double positionX, double positionY, double width) {
        super(parentGroup, positionX, positionY);
        Rectangle rectangle = new Rectangle(this, 0, 0, width, 20, 0, Color.LIGHT_GRAY);
        new Text(this, text, -3.1 * text.length(), 5, 0, new Font(Font.MONOSPACED, Font.PLAIN, 12));

        listeners = new ArrayList<ButtonListener>();

        rectangle.addMouseListener(new InnerMouseListener());
    }

    //pridanie pozorovatela udalosti kliknutia
    public void addButtonListener(ButtonListener listener) {
        listeners.add(listener);
    }
    
    //odstranenie pozorovatela udalosti kliknutia
    public void removeButtonListener(ButtonListener listener) {
        listeners.remove(listener);
    }

    //Oznamenie udalosti kliknutia na tlacidlo vsetkym pozorovatelom
    private void notifyClickEvent() {
        //ButtonEvent je immutable => listenery nemozu menit stav instancie, preto staci jedna instancia pre oznamenie vsetkym listnerom
        ButtonEvent event = new ButtonEvent(this); 
        for (ButtonListener listener : listeners) {
            listener.clicked(event);
        }
    }

    //Spracovanie udalosti kliknutia na obdlznik vykreslujuci tlacidlo
    private class InnerMouseListener extends MouseAdapter {
        @Override
        public void onMouseClicked(MouseEvent event) {
            notifyClickEvent();
        }
    }
}
