
import color.ColorModel;
import color.ColorPanel;
import color.NegateColorButton;
import color.RgbSliders;
import integer.BoundedIntegerModel;
import integer.Label;
import integer.Slider;
import java.awt.Color;
import net.useobjects.EventLoop;
import net.useobjects.Group;
import net.useobjects.MainActivity;
import net.useobjects.World;


public class MainMvc {

    public static void main(String[] args) {
        EventLoop.start(new MainActivity() {
            @Override
            public void onInit() {
                //vytvorenie okna
                World world = new World("MVC - farby", 500, 400);
                Group mainGroup = world.getRootGroup();

                //integer - model/view/controller (testovanie slider-a)
                BoundedIntegerModel integerModel = new BoundedIntegerModel(10, 0, 100); 
                Slider slider = new Slider(integerModel, mainGroup, 100, 350, Color.ORANGE);   
                Label label = new Label(integerModel, mainGroup, 200, 350);

                //color - model/view/controller
                ColorModel model = new ColorModel(new Color(100, 100, 100));
                ColorPanel panel = new ColorPanel(model, mainGroup, 200, 100, 100, 100);
                RgbSliders rgbSliders = new RgbSliders(model, mainGroup, 400, 150, -Math.PI / 2);
                NegateColorButton negButton = new NegateColorButton(model, mainGroup, 200, 250);
            }
        });
    }
}
