/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.samples;

import java.awt.Color;
import net.useobjects.AbstractGroup;
import net.useobjects.Line;
import net.useobjects.Polygon;
import net.useobjects.geom.Position;

public class Arrow
extends AbstractGroup {
    private final Line line;
    private final Polygon arrowhead;
    private static final Color DEFAULT_COLOR = Color.BLACK;

    public Arrow(AbstractGroup parent, double startX, double startY, double endX, double endY, Color color) {
        super(parent, 0.0, 0.0);
        this.line = new Line((AbstractGroup)this, startX, startY, endX, endY, color);
        this.arrowhead = new Polygon((AbstractGroup)this, endX, endY, color, true, 0, 0, -12, -5, -12, 5);
        this.arrowhead.setRotation(this.line.getRotation());
    }

    public Arrow(AbstractGroup parent, Position start, Position end, Color color) {
        this(parent, start.getX(), start.getY(), end.getX(), end.getY(), color);
    }

    public Arrow(AbstractGroup parent, double startX, double startY, double endX, double endY) {
        this(parent, startX, startY, endX, endY, DEFAULT_COLOR);
    }

    public Arrow(AbstractGroup parent, Position start, Position end) {
        this(parent, start, end, DEFAULT_COLOR);
    }

    public void setPosition(double startX, double startY, double endX, double endY) {
        this.setPosition(new Position(startX, startY), new Position(endX, endY));
    }

    public void setPosition(Position start, Position end) {
        this.line.setPosition(start, end);
        this.arrowhead.setPosition(end);
        this.arrowhead.setRotation(this.line.getRotation());
    }

    public void setStartPosition(double startX, double startY) {
        this.setStartPosition(new Position(startX, startY));
    }

    public void setStartPosition(Position start) {
        this.line.setStartPosition(start);
        this.arrowhead.setRotation(this.line.getRotation());
    }

    public void setEndPosition(double endX, double endY) {
        this.setEndPosition(new Position(endX, endY));
    }

    public void setEndPosition(Position end) {
        this.line.setEndPosition(end);
        this.arrowhead.setPosition(end);
        this.arrowhead.setRotation(this.line.getRotation());
    }

    public Position getStartPosition() {
        return this.line.getStartPosition();
    }

    public Position getEndPosition() {
        return this.line.getEndPosition();
    }

    public void setColor(Color color) {
        this.line.setColor(color);
        this.arrowhead.setColor(color);
    }

    public Color getColor() {
        return this.line.getColor();
    }
}

