
import java.awt.Color;
import net.useobjects.AbstractGroup;
import net.useobjects.Rectangle;
import net.useobjects.mouse.MouseAdapter;
import net.useobjects.mouse.MouseEvent;

//Implementacia s pouzitim adaptera (rozdiel je v implementacii vnorenej triedy InnerMouseListener)
public class Button2 extends AbstractGroup { 
    private Rectangle inner;
    private Rectangle outer;
    private static final Color NORMAL = new Color(0, 255, 255);
    private static final Color HOVER = new Color(0, 255, 0);
    private ButtonListener clickedListener; //private ClickedListener[] clickedListeners
    
    public Button2(AbstractGroup group, int positionX, int positionY) {
        super(group, positionX, positionY);
        outer = new Rectangle(this, 0, 0, 50, 40, 0, Color.BLUE);
        inner = new Rectangle(this, 0, 0, 48, 38, 0, NORMAL);
        
        clickedListener = null;
        
        outer.addMouseListener(new InnerMouseListener());
    }
    
    public void setButtonListener(ButtonListener listener) { //addClickedListener
        clickedListener = listener; //pridanie do pola
    }
    
    //public void removeClickedListener(ClickedListener listener) {
    //}
    
    private void fireClicked() {
        //for( ClickedListener listener: clickedListeners) {
        //    listener.clicked(new ClickedEvent(/*.....*/));
        //}
        if( clickedListener != null ) {
            clickedListener.clicked(new ButtonEvent(/*.....*/));
        }
    }
    
    //Ak pouzijeme adapter, nemusime implementovat vsetky metody rozhrania MouseListener
    //Trieda MouseAdapter implementuje rozhranie MouseListener tak,
    //ze vsetky metody definovane v rozhrani nic nerobia
    //Pri pouziti adaptera prekryjeme iba tie metody, ktore potrebujeme
    private class InnerMouseListener extends MouseAdapter {

        @Override
        public void onMouseClicked(MouseEvent event) {
            fireClicked();
        }

        @Override
        public void onMouseEntered(MouseEvent event) {
            inner.setColor(HOVER);
        }

        @Override
        public void onMouseExited(MouseEvent event) {
            inner.setColor(NORMAL);
        }
    }
}
