
import java.awt.Color;
import net.useobjects.AbstractGroup;
import net.useobjects.Polygon;
import net.useobjects.Rectangle;
import net.useobjects.geom.Position;

// Trieda AbstractGroup je urcena pre vytvaranie zlozitejsich objektov. 
// Je podobna triede Group, ale jej metody pre pridavanie objektov do skupiny, pracu s poziciou a rotaciu su protected, nie public.
// Trieda Group je nepriamo odvodena od AbstractGroup
public class Strom extends AbstractGroup {
	private Polygon horneKonare;
	private Polygon stredneKonare;
	private Polygon dolneKonare;
	private Rectangle kmen;
    
    private static final Color FARBA = Color.BLACK;
    
	public Strom(AbstractGroup nadradenaSkupina, int poziciaX, int poziciaY) {
            super(nadradenaSkupina, poziciaX, poziciaY, 0); 

            //pozicia pridavanych prvkov sa zadava v suradnicovej sustave zakladnej skupiny
            horneKonare   = new Polygon(this, 0, -40, FARBA, true, 20,0, 0,-16, -20,0);
            stredneKonare = new Polygon(this, 0, -25, FARBA, true, 20,0, 0,-16, -20,0);
            dolneKonare   = new Polygon(this, 0, -10, FARBA, true, 20,0, 0,-16, -20,0);
            kmen = new Rectangle(this, 0, -5, 5, 10, 0, FARBA, true);
	}

    public Position dajPoziciu() { 
        return getPosition(); //zdedene metoda
    }
}
