package sDedicnostou;

import java.awt.Color;
import spolocne.Position;

public class Line extends AbstractShape {
    private Position startPoint;
    private Position endPoint;

    public Line(Color color, Position startPoint, Position endPoint) {
        super(color);
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    public Position getStartPoint() {
        return new Position(startPoint);
    }

    public void setStartPoint(Position startPoint) {
        this.startPoint = new Position(startPoint);
    }
    
    public Position getEndPoint() {
        return new Position(endPoint);
    }

    public void setEndPoint(Position endPoint) {
        this.endPoint = new Position(endPoint);
    }
    
    public double getLength() {
        double diffX = startPoint.getX() - endPoint.getX();
        double diffY = startPoint.getY() - endPoint.getY();
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }

    @Override
    public String toString() {
        return super.toString() + ", suradnice=(" + startPoint + "->" + endPoint + "), ";
    }
}

