package bezDedicnosti;

import java.awt.Color;
import spolocne.Position;

public class Line {
    private Position startPoint;
    private Position endPoint;
    private Color color;

    public Line(Position startPoint, Position endPoint, Color color) {
        this.startPoint = new Position(startPoint);
        this.endPoint = new Position(endPoint);
        this.color = color; //immubable
    }

    public Position getStartPoint() {
        return new Position(startPoint);
    }

    public void setStartPoint(Position startPoint) {
        this.startPoint = new Position(startPoint);
    }
    
    public Position getEndPoint() {
        return new Position(endPoint);
    }

    public void setEndPoint(Position endPoint) {
        this.endPoint = new Position(endPoint);
    }
    
    public Color getColor() {
        return color; //immubable
    }

    public void setColor(Color color) {
        this.color = color; //immubable
    }
    
    public double getLength() {
        double diffX = startPoint.getX() - endPoint.getX();
        double diffY = startPoint.getY() - endPoint.getY();
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }

    @Override
    public String toString() {
        return "suradnice=(" + startPoint + "->" + endPoint + "), color=" + color;
    }
}
