
import java.awt.Color;
import net.useobjects.Circle;
import net.useobjects.Group;
import net.useobjects.timer.EventLoopTimer;
import net.useobjects.timer.TimerEvent;
import net.useobjects.timer.TimerListener;

//Skakajuca lopta bude listenerom tlacidla
public class JumpingBall implements ButtonListener {
    private Circle ball;
    private EventLoopTimer timer;

    public JumpingBall(Group group, int positionX, int positionY) {
        ball = new Circle(group, positionX, positionY, 10, Color.BLUE );
        timer = new EventLoopTimer(50, new JumpListener());
    }

    @Override
    public void clicked(ClickedEvent event) {
        if( ! timer.isRunning()) {
            timer.start();
        }
    }
    
    private class JumpListener implements TimerListener {
        private double startY;
        private double time;

        public JumpListener() {
            startY = ball.getPositionY();
            time = 0;
        }
        
        @Override
        public void onTimerEvent(TimerEvent event) {
            time += 0.15 + time/50;
            if( time < 7*Math.PI ) {
                double offset = 100*Math.exp(-time/5)*Math.abs(Math.sin(time));
                ball.setPositionY(startY - offset);
            }
            else {
                time = 0;
                timer.stop();
            }
        }
    }
}
