
import java.awt.Color;
import net.useobjects.Group;
import net.useobjects.Rectangle;
import net.useobjects.mouse.MouseEvent;
import net.useobjects.mouse.MouseListener;

//Tlacidlo, ktore pri kliknuti nan vygeneruje udalost ButtonListener.clicked(ClickedEvent event)
public class Button { 
    private Rectangle inner; //vnutorno tlacidla
    private Rectangle outer; //vonkajsi ram tlacidla
    private static final Color NORMAL = new Color(0, 255, 255); //farba ak mys nie je nad tlacidlom
    private static final Color HOVER = new Color(0, 255, 0); //farba ak je mys nad tlacidlom
    private ButtonListener buttonListener; //private ButtonListener[] buttonListeners //pre jednoduchost ma tlacidlo len jedneho pozorovatela (listenera)
    
    public Button(Group group, int positionX, int positionY) {
        outer = new Rectangle(group, positionX, positionY, 50, 40, 0, Color.BLUE);
        inner = new Rectangle(group, positionX, positionY, 48, 38, 0, NORMAL);
        
        buttonListener = null; //na zaciatku nie je ziadny listener
        
        outer.addMouseListener(new InnerMouseListener()); //pomocou tohoto obdlznika budeme zachytabat udalosti mysi, tieto udalosti budeme transformovat na udalosti tlacidla (ButtonEvent)
    }

    //zaregistrovanie pozorovatela
    public void setButtonListener(ButtonListener listener) { //addButtonListener
        buttonListener = listener; //pridanie do pola
    }
    
    //public void removeButtonListener(ButtonListener listener) {
    //}
    
    private void notifyClicked() {
        //for( ButtonListener listener: buttonListener) {
        //    listener.clicked(new ClickedEvent(/*.....*/));
        //}
        if( buttonListener != null ) {
            buttonListener.clicked(new ClickedEvent(/*.....*/));
        }
    }
    
    //tato trieda zabezpecuje
    //    podfarabenie tlacidla ak je nad nim mys
    //    transformaciu udalosti mysi na udalosti tlacidla
    private class InnerMouseListener implements MouseListener {

        @Override
        public void onMouseClicked(MouseEvent event) {
            notifyClicked();
        }

        @Override
        public void onMouseEntered(MouseEvent event) {
            inner.setColor(HOVER);
        }

        @Override
        public void onMouseExited(MouseEvent event) {
            inner.setColor(NORMAL);
        }

        @Override
        public void onMousePressed(MouseEvent event) {
        }

        @Override
        public void onMouseReleased(MouseEvent event) {
        }

        @Override
        public void onMouseDragged(MouseEvent event) {
        }

        @Override
        public void onMouseMoved(MouseEvent event) {
        }

        @Override
        public void onMouseWheelMoved(MouseEvent event) {
        }
    }
}
