
import java.awt.event.KeyEvent;
import net.useobjects.World;
import net.useobjects.keyboard.KeyboardEvent;
import net.useobjects.keyboard.KeyboardListener;
import net.useobjects.timer.EventLoopTimer;

public class Vysielacka {
    private Model model;
    private EventLoopTimer casovac;
    
    public Vysielacka(World svet, Model model) {
        this.model = model;
        svet.addKeyboardListener(new Riadenie());
    }
    
    private class Riadenie implements KeyboardListener {
        
        @Override
        public void onKeyPressed(KeyboardEvent event) {
            boolean right = event.contains(KeyEvent.VK_RIGHT);
            boolean left  = event.contains(KeyEvent.VK_LEFT);
            if ( right && ! left ) {
                model.natoc(Model.Smer.DOPRAVA);
            }
            if ( left && ! right ) {
                model.natoc(Model.Smer.DOLAVA);
            }

            if(event.contains(KeyEvent.VK_UP)) {
                model.zrychli();
            }
        }
        
        @Override
        public void onKeyReleased(KeyboardEvent event) {
        }
    }
}
