
import net.useobjects.Group;
import net.useobjects.Image;
import net.useobjects.timer.EventLoopTimer;
import net.useobjects.timer.TimerEvent;
import net.useobjects.timer.TimerListener;

public class Raketa implements Model {
    private Image raketa;
    private Image ohen;
    private Group skupina;
    private double rychlost;
    private static final double DEFAULT_RYCHLOST = 1;
    private int zostavajuciCasZapnutiaMotora; 
    private EventLoopTimer timer;

    public Raketa(Group hlavnaSkupina, int poziciaX, int poziciaY) {
        rychlost = DEFAULT_RYCHLOST;
        zostavajuciCasZapnutiaMotora = 0;
        
        skupina = new Group(hlavnaSkupina, poziciaX, poziciaY);
        raketa = new Image(skupina, 0, 0, 0, 1, getClass().getResource("/images/raketa.png"), 35, 25);
        ohen = new Image(skupina, -40, 0, 0, 1, getClass().getResource("/images/ohen.png"), 10, 10);
        ohen.setVisible(false);
        
        timer = new EventLoopTimer(20);
        timer.addTimerListener(new Motor());
        timer.start();
    }
    
    @Override
    public void natoc(Smer smer) {
        final double SILA_NATOCENIA = 0.05;
        if( smer == Model.Smer.DOPRAVA ) {
            skupina.rotate(SILA_NATOCENIA);
        }
        else {
            skupina.rotate(-SILA_NATOCENIA);
        }
    }

    @Override
    public void zrychli() { 
        rychlost += 0.1;
        zostavajuciCasZapnutiaMotora = 5;
    }
    
    private class Motor implements TimerListener {

        @Override
        public void onTimerEvent(TimerEvent event) {
            skupina.moveForwards(rychlost);
            
            if( zostavajuciCasZapnutiaMotora > 0 ) {
                ohen.setVisible(true);
            }
            else { 
                ohen.setVisible(false) ;
            }
            zostavajuciCasZapnutiaMotora --;

            if( rychlost >= DEFAULT_RYCHLOST ) {
                rychlost -= 0.01;
            }
        }
    }
}
