/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Color;
import java.awt.Graphics2D;
import net.useobjects.AbstractMovableRotatableComponent;
import net.useobjects.StringFormatter;
import net.useobjects.SyncGui;

abstract class AbstractSingleColorComponent
extends AbstractMovableRotatableComponent {
    protected static final Color DEFAULT_COLOR = Color.BLACK;
    private Color foregroundColor;

    public AbstractSingleColorComponent(double centerX, double centerY, double angle, Color color) {
        super(centerX, centerY, angle);
        this.foregroundColor = color;
    }

    public void setColor(final Color color) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractSingleColorComponent.this.foregroundColor = color;
                AbstractSingleColorComponent.this.fireChanged();
            }
        });
    }

    public Color getColor() {
        return new Color(this.foregroundColor.getRGB());
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        g2d.setColor(this.foregroundColor);
    }

    @Override
    public String toString() {
        return super.toString() + ", color=" + StringFormatter.ColorToString(this.foregroundColor);
    }
}

