/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.UIManager;
import net.useobjects.AbstractGroup;
import net.useobjects.AbstractSingleColorComponent;
import net.useobjects.SyncGui;

public final class Text
extends AbstractSingleColorComponent {
    private Font font;
    private String text;

    public Text(AbstractGroup parent, String text, double positionX, double positionY) {
        this(parent, text, positionX, positionY, 0.0);
    }

    public Text(AbstractGroup parent, String text, double positionX, double positionY, double angle) {
        this(parent, text, positionX, positionY, angle, UIManager.getDefaults().getFont("TextArea.font"));
    }

    public Text(AbstractGroup parent, String text, double positionX, double positionY, double angle, Font font) {
        this(parent, text, positionX, positionY, angle, Color.BLACK, font);
    }

    public Text(AbstractGroup parent, String text, double positionX, double positionY, double angle, Color color) {
        this(parent, text, positionX, positionY, angle, color, UIManager.getDefaults().getFont("TextArea.font"));
    }

    private Text(AbstractGroup parent, String text, double positionX, double positionY, double angle, Color color, Font font) {
        super(positionX, positionY, angle, color);
        this.text = text;
        this.font = font.deriveFont(font.getStyle());
        this.setParent(parent);
    }

    public Text(String text, double positionX, double positionY, double angle, Color color, Font font) {
        this(null, text, positionX, positionY, angle, color, font);
    }

    public Text(String text, double positionX, double positionY, double angle, Color color) {
        this(null, text, positionX, positionY, angle, color, UIManager.getDefaults().getFont("TextArea.font"));
    }

    public void setText(final String newText) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Text.this.text = newText;
                Text.this.fireChanged();
            }
        });
    }

    public String getText() {
        return this.text;
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        g2d.setFont(this.font);
        g2d.drawString(this.text, 0, 0);
    }

    @Override
    public String toString() {
        return super.toString() + ", font=" + this.font + ", text=\"" + this.text + "\"";
    }
}

