/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Set;
import net.useobjects.AbstractGroup;
import net.useobjects.ComponentPropertyEvent;
import net.useobjects.ComponentPropertyListener;
import net.useobjects.SyncGui;
import net.useobjects.geom.Position;

abstract class AbstractDrawableObject {
    private AbstractGroup parent = null;
    private Set<ComponentPropertyListener> changeListeners = new HashSet<ComponentPropertyListener>();
    private boolean visible = true;

    void throwIfNegative(double argument, String message) {
        if (argument < 0.0) {
            throw new IllegalArgumentException(message + ": " + argument);
        }
    }

    void draw(Graphics2D g2d) {
        if (this.visible) {
            this.drawImpl(g2d);
        }
    }

    abstract void drawImpl(Graphics2D var1);

    public void setVisible(final boolean visible) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (AbstractDrawableObject.this.visible != visible) {
                    AbstractDrawableObject.this.visible = visible;
                    AbstractDrawableObject.this.fireChanged();
                }
            }
        });
    }

    public boolean isVisible() {
        return this.visible;
    }

    void addComponentPropertyListener(ComponentPropertyListener listener) {
        this.changeListeners.add(listener);
    }

    void removeComponentPropertyListener(ComponentPropertyListener listener) {
        this.changeListeners.remove(listener);
    }

    void fireChanged() {
        for (ComponentPropertyListener listener : this.changeListeners) {
            listener.onPropertyChanged(new ComponentPropertyEvent());
        }
    }

    AbstractGroup getParent() {
        return this.parent;
    }

    final void setParent(AbstractGroup parent) {
        if (this.parent != parent) {
            if (this.parent != null && this.parent.contains(this)) {
                this.parent.remove(this);
            }
            this.parent = parent;
            if (this.parent != null && !this.parent.contains(this)) {
                this.parent.add(this);
            }
            this.fireChanged();
        }
    }

    Position externalToInternalCoordinates(Position externalPosition) {
        return new Position(externalPosition);
    }

    Position internalToExternalCoordinates(Position internalPosition) {
        return new Position(internalPosition);
    }

    Position internalToGlobalCoordinates(Position internalPosition) {
        Position position = this.internalToExternalCoordinates(internalPosition);
        if (this.getParent() != null) {
            return this.getParent().internalToGlobalCoordinates(position);
        }
        return position;
    }

    Position globalToInternalCoordinates(Position globalPosition) {
        Position position = null;
        position = this.getParent() != null ? this.getParent().globalToInternalCoordinates(globalPosition) : globalPosition;
        return this.externalToInternalCoordinates(position);
    }
}

