/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import net.useobjects.MouseManager;
import net.useobjects.MouseStatus;
import net.useobjects.World;
import net.useobjects.World2DChangeEvent;
import net.useobjects.World2DChangeListener;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseButton;

class Window2D
extends JPanel {
    private World world;
    private MouseStatus mouseStatus;
    private MouseManager mouseManager;
    private int[][] gridGaps = new int[][]{{10}, {10}};
    private boolean gridShowed;

    public Window2D(World world, int width, int height) {
        this.world = world;
        Dimension size = new Dimension(width, height);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setBackground(Color.white);
        this.mouseStatus = new MouseStatus();
        this.addMouseListener(this.mouseStatus);
        this.addMouseMotionListener(this.mouseStatus);
        this.gridShowed = false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.world.getRootGroup().draw(g2d);
    }

    public boolean isMouseButtonDown(MouseButton mouseButton) {
        return this.mouseStatus.isMouseButtonDown(mouseButton);
    }

    public Position getActualMousePosition() {
        return this.mouseStatus.getMousePosition();
    }

    private class InnerWorld2DChangeListener
    implements World2DChangeListener {
        private InnerWorld2DChangeListener() {
        }

        @Override
        public void world2DChanged(World2DChangeEvent event) {
            Window2D.this.repaint();
        }
    }
}

