/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import net.useobjects.AbstractGroup;
import net.useobjects.AbstractSingleColorFillComponent;
import net.useobjects.SyncGui;
import net.useobjects.geom.Position;

public final class Circle
extends AbstractSingleColorFillComponent {
    private double radius;

    public Circle(AbstractGroup parent, Position center, double radius) {
        this(parent, center.getX(), center.getY(), radius, Color.BLACK);
    }

    public Circle(AbstractGroup parent, Position center, double radius, Color color) {
        this(parent, center.getX(), center.getY(), radius, color);
    }

    public Circle(AbstractGroup parent, Position center, double radius, Color color, boolean fill) {
        this(parent, center.getX(), center.getY(), radius, color);
    }

    public Circle(AbstractGroup parent, double centerX, double centerY, double radius) {
        this(parent, centerX, centerY, radius, Color.BLACK);
    }

    public Circle(AbstractGroup parent, double centerX, double centerY, double radius, Color color) {
        this(parent, centerX, centerY, radius, color, true);
    }

    public Circle(AbstractGroup parent, double centerX, double centerY, double radius, Color color, boolean fill) {
        super(centerX, centerY, 0.0, color, fill);
        this.radius = radius;
        this.setParent(parent);
    }

    public Circle(double centerX, double centerY, double radius, Color color, boolean fill) {
        this(null, centerX, centerY, radius, color, fill);
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        if (this.isFilled()) {
            g2d.fill(this.getEllipse());
        } else {
            g2d.draw(this.getEllipse());
        }
    }

    private Ellipse2D.Double getEllipse() {
        return new Ellipse2D.Double(-this.radius, -this.radius, 2.0 * this.radius, 2.0 * this.radius);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(final double newRadius) {
        this.throwIfNegative(newRadius, "zaporny polomer");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Circle.this.radius = newRadius;
                Circle.this.fireChanged();
            }
        });
    }

    @Override
    public boolean containsInternal(Position internalPosition) {
        double y;
        double x = internalPosition.getX();
        return x * x + (y = internalPosition.getY()) * y <= this.radius * this.radius;
    }

    @Override
    public String toString() {
        return super.toString() + ", radius=" + this.radius;
    }
}

