/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.useobjects.AbstractDrawableMovableRotatableObject;
import net.useobjects.AbstractDrawableObject;
import net.useobjects.ComponentPropertyEvent;
import net.useobjects.ComponentPropertyListener;
import net.useobjects.MouseEventDrawableSource;
import net.useobjects.MouseManager;
import net.useobjects.MouseMediator;
import net.useobjects.SyncGui;
import net.useobjects.SyncRunnableWithResult;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseListener;

public abstract class AbstractGroup
extends AbstractDrawableMovableRotatableObject
implements ComponentPropertyListener,
MouseEventDrawableSource {
    private List<AbstractDrawableObject> items = new ArrayList<AbstractDrawableObject>();
    private MouseMediator mouseMediator;

    public AbstractGroup(AbstractGroup parent, Position position) {
        this(parent, position.getX(), position.getY());
    }

    public AbstractGroup(AbstractGroup parent, double positionX, double positionY) {
        this(parent, positionX, positionY, 0.0);
    }

    public AbstractGroup(AbstractGroup parent, Position position, double angle) {
        this(parent, position.getX(), position.getY(), angle);
    }

    public AbstractGroup(AbstractGroup parent, double positionX, double positionY, double angle) {
        super(positionX, positionY, angle);
        this.setParent(parent);
    }

    public AbstractGroup(double positionX, double positionY, double angle) {
        this(null, positionX, positionY, angle);
    }

    protected void add(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractGroup.this.items.add(drawable);
                drawable.setParent(AbstractGroup.this);
                drawable.addComponentPropertyListener(AbstractGroup.this);
                if (drawable instanceof MouseEventDrawableSource) {
                    ((MouseEventDrawableSource)((Object)drawable)).setMouseManager(AbstractGroup.this.getMouseManager());
                }
                AbstractGroup.this.fireChanged();
            }
        });
    }

    protected void remove(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractGroup.this.items.remove(drawable);
                drawable.removeComponentPropertyListener(AbstractGroup.this);
                if (drawable.getParent() == AbstractGroup.this) {
                    drawable.setParent(null);
                }
                if (drawable instanceof MouseEventDrawableSource) {
                    ((MouseEventDrawableSource)((Object)drawable)).setMouseManager(null);
                }
                AbstractGroup.this.fireChanged();
            }
        });
    }

    protected void removeAll() {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                while (!AbstractGroup.this.items.isEmpty()) {
                    AbstractGroup.this.remove((AbstractDrawableObject)AbstractGroup.this.items.get(0));
                }
            }
        });
    }

    protected boolean contains(final AbstractDrawableObject drawable) {
        return SyncGui.invokeAndWait(new SyncRunnableWithResult<Boolean>(){

            @Override
            public Boolean runAndReturnResult() {
                for (AbstractDrawableObject d : AbstractGroup.this.items) {
                    if (d != drawable) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void onPropertyChanged(ComponentPropertyEvent event) {
        this.fireChanged();
    }

    protected Iterator<AbstractDrawableObject> iterator() {
        return this.items.iterator();
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        for (AbstractDrawableObject item : this.items) {
            Graphics2D copy = (Graphics2D)g2d.create();
            item.draw(copy);
        }
    }

    private MouseMediator getMouseMediator() {
        if (this.mouseMediator == null) {
            this.mouseMediator = new MouseMediator(this);
        }
        return this.mouseMediator;
    }

    @Override
    public void setMouseManager(MouseManager manager) {
        this.getMouseMediator().setMouseManager(manager);
        for (AbstractDrawableObject drawable : this.items) {
            if (!(drawable instanceof MouseEventDrawableSource)) continue;
            ((MouseEventDrawableSource)((Object)drawable)).setMouseManager(manager);
        }
    }

    private MouseManager getMouseManager() {
        return this.getMouseMediator().getMouseManager();
    }

    @Override
    public boolean containsInternal(Position position) {
        for (AbstractDrawableObject drawable : this.items) {
            Position pos;
            if (!(drawable instanceof MouseEventDrawableSource) || !(drawable instanceof AbstractDrawableObject) || !((MouseEventDrawableSource)((Object)drawable)).containsInternal(pos = drawable.externalToInternalCoordinates(position))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.getMouseMediator().addMouseChangedListener(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        this.getMouseMediator().removeMouseChangedListener(listener);
    }

    @Override
    public String toString() {
        String res = "[";
        for (AbstractDrawableObject drawable : this.items) {
            res = res + drawable.toString();
            res = res + ", ";
        }
        res = res.replaceAll(", $", "");
        res = res + "]";
        return res;
    }
}

