
import net.useobjects.Ellipse;
import net.useobjects.Group;

public class PosuvatelneKruhy implements Posuvatelny {

	private Ellipse stredny;
	private Ellipse[] krajne;
	private static final int POCET_KRAJNYCH = 10; //pocet krajnych kruhov
	private static final int POLOMER = 50; //polomer "obeznej drahy"

	public PosuvatelneKruhy(Group parent, int poziciaX, int poziciaY) {
		stredny = new Ellipse(parent, poziciaX, poziciaY, 20, 20);

		krajne = new Ellipse[POCET_KRAJNYCH];
		for (int i = 0; i < krajne.length; i++) {
			double uhol = 2 * Math.PI * i / krajne.length;
			double x = poziciaX + POLOMER * Math.cos(uhol);
			double y = poziciaY + POLOMER * Math.sin(uhol);
			krajne[i] = new Ellipse(parent, x, y, 10, 10);
		}
	}

	@Override
	public void posun(int posuvX, int posuvY) {
		stredny.move(posuvX, posuvY);
		for (Ellipse krajna : krajne) {
			krajna.move(posuvX, posuvY);
		}
	}

	@Override
	public void nastavPoziciu(int poziciaX, int poziciaY) {
		stredny.setPosition(poziciaX, poziciaY);
		for (int i = 0; i < krajne.length; i++) {
			double uhol = 2 * Math.PI * i / krajne.length;
			double x = poziciaX + POLOMER * Math.cos(uhol);
			double y = poziciaY + POLOMER * Math.sin(uhol);
			krajne[i].setPosition(x, y);
		}
	}
}
