/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.util.HashSet;
import java.util.Set;
import net.useobjects.AbstractDrawableObject;
import net.useobjects.DrawableChangeEvent;
import net.useobjects.DrawableChangeListener;
import net.useobjects.Group;
import net.useobjects.World2DChangeEvent;
import net.useobjects.World2DChangeListener;

class World2DModel
implements DrawableChangeListener {
    private static final int MIN_WIDTH = 250;
    private static final int MIN_HEIGHT = 200;
    private Group items;
    private final int width;
    private final int height;
    private Set<World2DChangeListener> changedListeners;

    public World2DModel() {
        this(0, 0);
    }

    public World2DModel(int width, int height) {
        this.width = Math.max(width, 250);
        this.height = Math.max(height, 200);
        this.items = new Group(null, 0.0, 0.0);
        this.items.addDrawableChangeListener(this);
        this.changedListeners = new HashSet<World2DChangeListener>();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void add(AbstractDrawableObject drawable) {
        this.items.add(drawable);
    }

    public void remove(AbstractDrawableObject drawable) {
        this.items.remove(drawable);
    }

    public Group getRootGroup() {
        return this.items;
    }

    public void fireChanged() {
        for (World2DChangeListener listener : this.changedListeners) {
            listener.world2DChanged(new World2DChangeEvent(this));
        }
    }

    public void addWorld2DChangedListener(World2DChangeListener listener) {
        this.changedListeners.add(listener);
    }

    public void removeWorld2DChangedListener(World2DChangeListener listener) {
        this.changedListeners.remove(listener);
    }

    @Override
    public void drawableChanged(DrawableChangeEvent event) {
        this.fireChanged();
    }
}

