/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.useobjects.AbstractDrawableMovableRotatableResizeableObject;
import net.useobjects.AbstractGroup;

class AbstractImage
extends AbstractDrawableMovableRotatableResizeableObject {
    private BufferedImage originalImage = null;
    private BufferedImage colorizedImage = null;
    private int referencePointX;
    private int referencePointY;
    private String imageFileString;

    public AbstractImage(AbstractGroup parent, double positionX, double positionY, double angle, double resizeFactor, String imageFile, int imageReferencePointX, int imageReferencePointY) {
        this(parent, positionX, positionY, angle, resizeFactor, new File(imageFile), imageReferencePointX, imageReferencePointY);
    }

    public AbstractImage(AbstractGroup parent, double positionX, double positionY, double angle, double resizeFactor, File imageFile, int imageReferencePointX, int imageReferencePointY) {
        super(positionX, positionY, angle, resizeFactor);
        this.setImageImpl(imageFile, imageReferencePointX, imageReferencePointY);
        this.setParent(parent);
    }

    public AbstractImage(AbstractGroup parent, double positionX, double positionY, double angle, double resizeFactor, URL imageFile, int imageReferencePointX, int imageReferencePointY) {
        super(positionX, positionY, angle, resizeFactor);
        this.setImageImpl(imageFile, imageReferencePointX, imageReferencePointY);
        this.setParent(parent);
    }

    private void setImageImpl(File imageFile, int imageReferencePointX, int imageReferencePointY) {
        try {
            this.setImage(imageFile.toURI().toURL(), imageReferencePointX, imageReferencePointY);
        }
        catch (MalformedURLException ex) {
            System.err.println("ImageView: chybna cesta ku obrazku \"" + imageFile.getAbsolutePath() + "\"");
            ex.printStackTrace();
        }
    }

    private void setImageImpl(URL imageFile, int imageReferencePointX, int imageReferencePointY) {
        try {
            this.colorizedImage = this.originalImage = ImageIO.read(imageFile);
            this.referencePointX = imageReferencePointX;
            this.referencePointY = imageReferencePointY;
            this.imageFileString = imageFile.getFile();
            this.fireChanged();
        }
        catch (IOException exception) {
            System.err.println("ImageView: chyba pri nacitani obrazka \"" + imageFile.getFile() + "\"");
            exception.printStackTrace();
        }
    }

    protected void setImage(String imageFile, int imageReferencePointX, int imageReferencePointY) {
        this.setImage(new File(imageFile), imageReferencePointX, imageReferencePointY);
    }

    protected void setImage(File imageFile, int imageReferencePointX, int imageReferencePointY) {
        this.setImageImpl(imageFile, imageReferencePointX, imageReferencePointY);
    }

    protected void setImage(URL imageFile, int imageReferencePointX, int imageReferencePointY) {
        this.setImageImpl(imageFile, imageReferencePointX, imageReferencePointY);
    }

    protected void setColorGrayscaleFilter() {
        this.pixelsTransform(new PixelTransformation(){

            @Override
            public void transfrom(int[] pixel) {
                int gray;
                pixel[0] = gray = (int)(0.2989 * (double)pixel[0] + 0.587 * (double)pixel[1] + 0.114 * (double)pixel[2]);
                pixel[1] = gray;
                pixel[2] = gray;
            }
        });
        this.fireChanged();
    }

    protected void setColorToneFilter(float hue, float saturation) {
        class Tr
        implements PixelTransformation {
            private float _hue;
            private float _saturation;

            public Tr(float hue, float saturation) {
                this._hue = hue;
                this._saturation = saturation;
            }

            @Override
            public void transfrom(int[] pixel) {
                float brightness = (0.2989f * (float)pixel[0] + 0.587f * (float)pixel[1] + 0.114f * (float)pixel[2]) / 255.0f;
                int color = Color.HSBtoRGB(this._hue, this._saturation, brightness);
                pixel[0] = color >> 16 & 0xFF;
                pixel[1] = color >> 8 & 0xFF;
                pixel[2] = color & 0xFF;
            }
        }
        this.pixelsTransform(new Tr(hue, saturation));
        this.fireChanged();
    }

    private void pixelsTransform(PixelTransformation transform) {
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.colorizedImage = new BufferedImage(width, height, 6);
        WritableRaster originalRaster = this.originalImage.getRaster();
        WritableRaster transformedRaster = this.colorizedImage.getRaster();
        int[] pixel = new int[4];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                originalRaster.getPixel(x, y, pixel);
                transform.transfrom(pixel);
                transformedRaster.setPixel(x, y, pixel);
            }
        }
    }

    protected void resetColorFilter() {
        this.colorizedImage = this.originalImage;
        this.fireChanged();
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        g2d.drawImage((Image)this.colorizedImage, -this.referencePointX, -this.referencePointY, null);
    }

    @Override
    public String toString() {
        return super.toString() + ", imageFile=" + this.imageFileString + ", referencePointX=" + this.referencePointX + ", referencePointY=" + this.referencePointY;
    }

    private static interface PixelTransformation {
        public void transfrom(int[] var1);
    }
}

