package experiment;

/**
 * Trieda reprezentujuca vedecky experiment
 */
public class Experiment {
    private String nazov; 
    private PozorovatelExperimentu[] pozorovatelia; //referencie na vsetkych registorvanych pozorovatelov

    /**
     * Vytvory novy experiment so zadanym nazvom
     * @param nazovExperimentu nazov experimentu 
     */
    public Experiment(String nazovExperimentu) {
        nazov = nazovExperimentu;
        pozorovatelia = new PozorovatelExperimentu[100]; //pre jednoduchost bude maximalny pocet pozorovatelov obmedzeny
    }

    /**
     * Vrati nazov experimentu
     * @return nazov experimentu
     */
    public String getNazov() {
        return nazov;
    }

    /**
     * Zaregistruje pozorovatela do zoznamu pozorovatelov, ktorym bude odosielat informacie o experimente
     * @param pozorovatel zaregistrovany pozorovatel
     */
    public void zaregistrujPozorovatela(PozorovatelExperimentu pozorovatel) {
        //doplnte implementaciu
    }

    /**
     * Odregistruje pozorovatela zo zoznamu pozorovatelov, ktorym posiela informacie o experimente
     * @param pozorovatel odregistrovay pozorovatel
     */
    public void odregistrujPozorovatela(PozorovatelExperimentu pozorovatel) {
        //doplne implementaciu
    }
    
    /**
     * Metoda oznamy vsetkym registrovanym pozorovatelom zaciatok experimentu
     */
    private void oznamZaciatok() {
        for(int i = 0; i < pozorovatelia.length; i++) {
            if( pozorovatelia[i] != null ) {
                pozorovatelia[i].zaciatokExperimentu(this);
            }
        }
    }

    /**
     * Metoda oznamy vsetkym registrovanym pozorovatelom zmenu teploty
     */
    private void oznamZmenuTeploty(int cas, int teplota) {
        for(int i = 0; i < pozorovatelia.length; i++) {
            if( pozorovatelia[i] != null ) {
                pozorovatelia[i].zmenaTeploty(this, new UdalostVExperimente(cas, teplota));
            }
        }
    }
    
    /**
     * Metoda oznamy vsetkym registrovanym pozorovatelom koniec experimentu
     */
    private void oznamKoniec() {
        for(int i = 0; i < pozorovatelia.length; i++) {
            if( pozorovatelia[i] != null ) {
                pozorovatelia[i].koniecExperimentu(this);
            }
        }
    }
    
    /**
     * Simulacia vykonavania experimentu
     */
    public void vykonaj() {
        //tu budeme simulovat priebeh experimentu
        oznamZaciatok();
        oznamZmenuTeploty(0, 20);
        oznamZmenuTeploty(1, 50);
        oznamZmenuTeploty(2, 50);
        oznamZmenuTeploty(3, 150);
        oznamZmenuTeploty(4, 100);
        oznamKoniec();
    }
}
