
import java.awt.Color;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.draw.drawable.LineView;
import net.useobjects.draw.drawable.RectangleView;
import net.useobjects.geom.Position;

public class Vaha {

    private Miska miska;
    private RectangleView ram;
    private Cifernik cifernik; //analogove zobrazenie
    private Ciselnik ciselnik; //digitalne zobrazenie
    private LineView rameno;
    private int nulovaVyskaMisky; //y-ova suradnica pozicie misky, kde na miske nic nie je
    private static final int MAX_VAHA = 100; //kazda vaha bude vazit maximalne do 100
    private Zavazie zavazie; //referencia zavazie polozene na vahu. Ak na vahe nie je ziadne zavazie tak ma hodnotu null
    private Position zavaziePovodna; //pozicia zavazia pred polozenim na vahu, aby sme vedeli kam vratit zavazie

    public Vaha(GroupView skupina, int poziciaX, int poziciaY) {
        nulovaVyskaMisky = poziciaY - 50;

        ram = new RectangleView(skupina, poziciaX, poziciaY, 100, 140, 0, Color.BLACK, false);
        cifernik = new Cifernik(skupina, poziciaX, poziciaY - 20, 40);
        miska = new Miska(skupina, poziciaX - 100, nulovaVyskaMisky);
        rameno = new LineView(skupina, poziciaX - 75, nulovaVyskaMisky, 0, Color.BLACK, 50);
        ciselnik = new Ciselnik(skupina, poziciaX - 20, poziciaY + 50, 0, "kg"); 

        zavazie = null;
    }

    public void dajNaVahu(Zavazie noveZavazie) {
        if (zavazie != noveZavazie) {
            //odstranenie
            if (zavazie != null) {
                zavazie.nastavPoziciu(zavaziePovodna);
            }
            
            //pridanie
            zavazie = noveZavazie;
            int miskaY;
            int vaha;
            if (zavazie != null) {
                vaha = Math.min(zavazie.dajVahu(), MAX_VAHA);
                miskaY = nulovaVyskaMisky + vaha;
                zavaziePovodna = zavazie.dajPoziciu();
                zavazie.nastavPoziciu((int) miska.dajPoziciuX(), miskaY-miska.dajVysku()-zavazie.dajVysku()/2);
            } else {
                vaha = 0;
                miskaY = nulovaVyskaMisky;
            }
            miska.nastavPoziciuY(miskaY);
            rameno.setPositionY(miskaY);
            cifernik.nastavNatocenie((double) vaha / MAX_VAHA * 2 * Math.PI);
            ciselnik.nastavHodnotu(vaha);
        }
    }
    
    public Zavazie dajZavazie() {
        return zavazie;
    }
}
