/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.window;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import net.useobjects.draw.drawable.AbstractDrawableObject;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.draw.event.DrawableChangeEvent;
import net.useobjects.draw.event.DrawableChangeListener;
import net.useobjects.window.World2DChangeEvent;
import net.useobjects.window.World2DChangeListener;

public class World2DModel
implements DrawableChangeListener {
    private static final int MIN_WIDTH = 250;
    private static final int MIN_HEIGHT = 200;
    private GroupView items;
    private final int width;
    private final int height;
    private Set<World2DChangeListener> changedListeners;

    public World2DModel() {
        this(0, 0);
    }

    public World2DModel(int width, int height) {
        this.width = Math.max(width, 250);
        this.height = Math.max(height, 200);
        this.items = new GroupView(null, 0.0, 0.0);
        this.items.addDrawableChangeListener(this);
        this.changedListeners = new HashSet<World2DChangeListener>();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void add(AbstractDrawableObject drawable) {
        this.items.add(drawable);
    }

    public void remove(AbstractDrawableObject drawable) {
        this.items.remove(drawable);
    }

    public GroupView getRootGroup() {
        return this.items;
    }

    public void fireChanged() {
        for (World2DChangeListener listener : this.changedListeners) {
            listener.world2DChanged(new World2DChangeEvent(this));
        }
    }

    public void addWorld2DChangedListener(World2DChangeListener listener) {
        this.changedListeners.add(listener);
    }

    public void removeWorld2DChangedListener(World2DChangeListener listener) {
        this.changedListeners.remove(listener);
    }

    @Override
    public void drawableChanged(DrawableChangeEvent event) {
        this.fireChanged();
    }
}

