/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.mouse;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import net.useobjects.mouse.MouseMediator;
import net.useobjects.window.Window2D;

public class MouseManager
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Window2D window;
    private List<MouseMediator> mediatorsList;

    public MouseManager(Window2D window) {
        this.window = window;
        this.mediatorsList = new ArrayList<MouseMediator>();
    }

    public Window2D getWindow() {
        return this.window;
    }

    public void addMouseMediator(MouseMediator mediator) {
        if (!this.mediatorsList.contains(mediator)) {
            this.mediatorsList.add(mediator);
        }
    }

    public void removeMouseMediator(MouseMediator mediator) {
        this.mediatorsList.remove(mediator);
    }

    public boolean containMouseMediator(MouseMediator mediator) {
        for (MouseMediator med : this.mediatorsList) {
            if (med != mediator) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (MouseMediator mediator : this.mediatorsList.toArray(new MouseMediator[0])) {
            mediator.fireMouseClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (MouseMediator mediator : this.mediatorsList.toArray(new MouseMediator[0])) {
            mediator.fireMousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (MouseMediator mediator : this.mediatorsList.toArray(new MouseMediator[0])) {
            mediator.fireMouseReleased(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (MouseMediator mediator : this.mediatorsList.toArray(new MouseMediator[0])) {
            mediator.fireEnteredExited(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (MouseMediator mediator : this.mediatorsList.toArray(new MouseMediator[0])) {
            mediator.fireEnteredExited(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        for (MouseMediator mediator : this.mediatorsList.toArray(new MouseMediator[0])) {
            mediator.fireEnteredExited(e);
            mediator.fireMouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (MouseMediator mediator : this.mediatorsList.toArray(new MouseMediator[0])) {
            mediator.fireEnteredExited(e);
            mediator.fireMouseMoved(e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        for (MouseMediator mediator : this.mediatorsList.toArray(new MouseMediator[0])) {
            mediator.fireMouseWheelMoved(e);
        }
    }
}

