public class Obdlznik {

    private Pozicia stred; //pouzit co najvystiznejsi nazov (pozicia stredu obdlznika)
    private int sirka;
    private int vyska;
    private final String NAZOV;
    private final int ID;
    private static int pocetInstancii = 0;

    public Obdlznik(String nazov, int stredX, int stredY, int sirka, int vyska) {
        this.stred = new Pozicia(stredX, stredY); //v tomto pripade vytvorime kopiu
            //pretoze nechceme aby niekto iny mimo tejto triedy mal referenciu na stred obdlznika 
            //a mohol ju menit bez toho aby o tom obdlznik vedel
            //Suvisi to s tym ze medzi obdlznikom a poziciou je vztah kompozicie
            
            //(V inom priklade by mohlo byt vhodne riesenie kopirovat referenciu, nie vytvarat kopiu.
            //Napriklad pri vztahu predmet a studenti, ktory navstevuju predmet)
        
        this.sirka = sirka;
        this.vyska = vyska;
        Obdlznik.pocetInstancii++;
        this.ID = Obdlznik.pocetInstancii;
        this.NAZOV = (nazov != null) ? nazov : vytvorNazov(this.ID);
    }

    public Obdlznik(int stredX, int stredY, int sirka, int vyska) {
        this(null, stredX, stredY, sirka, vyska); //vyuzijeme hotovy kod, v pripade potreby zmeny nemusime prepisovat kod viac krat
    }

    public Obdlznik(String nazov, Pozicia stred, int sirka, int vyska) {
        this(nazov, stred.dajX(), stred.dajY(), sirka, vyska); 
    }

    public Obdlznik(Pozicia stred, int sirka, int vyska) {
        this(null, stred, sirka, vyska);
    }

    public Pozicia dajStred() {
        return new Pozicia(stred); //vraciame kopiu
        //ak by sme vratili referenciu na atribut stred,
        //tak v inej casti kodu by sa dalo manipulovat so stredom, bez toho aby o tom obdlznik vedel
        //co v tomto pripade nechceme 
        //Medzi obdlznikom a poziciou je vztah kompozicie
        
        //V inych pripadoch moze byt lepsie vratit referenciu na atribut, nie jeho kopiu.
        //Napriklad pri vztahu predmet a studenti, ktory navstevuju predmet.
    }

    public int dajSirku() {
        return sirka; //tiez vraciame kopiu (aj ked inu moznost ani nemame)
    }

    public int dajVysku() {
        return vyska; //vraciame kopiu
    }

    public int dajId() {
        return ID;
    }

    public String dajNazov() {
        return NAZOV; //nemusime vytvarat kopiu, pretoze instancie String su nemenne (ich obsah sa neda zmenit)
    }

    public void nastavStred(int stredX, int stredY) {
        stred = new Pozicia(stredX, stredY);
    }

    public void nastavStred(Pozicia stred) {
        nastavStred(stred.dajX(), stred.dajY()); //vytvori sa kopia
    }

    public void nastavSirku(int sirka) {
        this.sirka = sirka;
    }

    public void nastavVysku(int vyska) {
        this.vyska = vyska;
    }

    public void nastavRozmery(int sirka, int vyska) {
        nastavSirku(sirka);
        nastavVysku(vyska);
    }

    public int dajObsah() {
        return sirka * vyska;
    }

    @Override //vyznam anotacie override bude objasneny neskor
    public String toString() {
        return "nazov = \"" + NAZOV + "\", id = " + ID + ", stred = " + stred.toString() + ", sirka = " + sirka + ", vyska = " + vyska;
        //vyuzili sme metodu toString triedy stred
    }

    private static String vytvorNazov(int id) {
        return String.format("obdlznik%02d", id);
    }

    public static int dajPocetInstancii() {
        return pocetInstancii;
    }
}
