/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.useobjects.draw.drawable.AbstractDrawableMovableRotatableObject;
import net.useobjects.draw.drawable.AbstractDrawableObject;
import net.useobjects.draw.drawable.AbstractView;
import net.useobjects.draw.event.DrawableChangeEvent;
import net.useobjects.draw.event.DrawableChangeListener;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseChangedListener;
import net.useobjects.mouse.MouseEventDrawableSource;
import net.useobjects.mouse.MouseManager;
import net.useobjects.mouse.MouseMediator;
import net.useobjects.sync.RunnableWithResult;
import net.useobjects.sync.SyncGui;

public class GroupView
extends AbstractDrawableMovableRotatableObject
implements DrawableChangeListener,
Iterable<AbstractDrawableObject>,
MouseEventDrawableSource {
    private List<AbstractDrawableObject> items = new ArrayList<AbstractDrawableObject>();
    private MouseMediator mouseMediator;

    public GroupView(GroupView parent, Position position) {
        this(parent, position.getX(), position.getY());
    }

    public GroupView(GroupView parent, double positionX, double positionY) {
        this(parent, positionX, positionY, 0.0);
    }

    public GroupView(GroupView parent, Position position, double angle) {
        this(parent, position.getX(), position.getY(), angle);
    }

    public GroupView(GroupView parent, double positionX, double positionY, double angle) {
        super(positionX, positionY, angle);
        this.setParent(parent);
    }

    public GroupView(double positionX, double positionY, double angle) {
        this(null, positionX, positionY, angle);
    }

    public void add(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GroupView.this.items.add(drawable);
                drawable.setParent(GroupView.this);
                drawable.addDrawableChangeListener(GroupView.this);
                if (drawable instanceof MouseEventDrawableSource) {
                    ((MouseEventDrawableSource)((Object)drawable)).setMouseManager(GroupView.this.getMouseManager());
                }
                GroupView.this.fireChanged();
            }
        });
    }

    public void add(AbstractView abstractView) {
        this.add(abstractView.getBaseGroup());
    }

    public void remove(final AbstractDrawableObject drawable) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GroupView.this.items.remove(drawable);
                drawable.removeDrawableChangeListener(GroupView.this);
                if (drawable.getParent() == GroupView.this) {
                    drawable.setParent(null);
                }
                if (drawable instanceof MouseEventDrawableSource) {
                    ((MouseEventDrawableSource)((Object)drawable)).setMouseManager(null);
                }
                GroupView.this.fireChanged();
            }
        });
    }

    public void remove(AbstractView abstractView) {
        this.remove(abstractView.getBaseGroup());
    }

    public void removeAll() {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                while (!GroupView.this.items.isEmpty()) {
                    GroupView.this.remove((AbstractDrawableObject)GroupView.this.items.get(0));
                }
            }
        });
    }

    public boolean contains(final AbstractDrawableObject drawable) {
        return SyncGui.invokeAndWait(new RunnableWithResult<Boolean>(){

            @Override
            public Boolean runAndReturnResult() {
                for (AbstractDrawableObject d : GroupView.this.items) {
                    if (d != drawable) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public boolean contains(AbstractView view) {
        return this.contains(view.getBaseGroup());
    }

    @Override
    public void drawableChanged(DrawableChangeEvent event) {
        this.fireChanged();
    }

    @Override
    public Iterator<AbstractDrawableObject> iterator() {
        return this.items.iterator();
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        for (AbstractDrawableObject item : this.items) {
            Graphics2D copy = (Graphics2D)g2d.create();
            item.draw(copy);
        }
    }

    private MouseMediator getMouseMediator() {
        if (this.mouseMediator == null) {
            this.mouseMediator = new MouseMediator(this);
        }
        return this.mouseMediator;
    }

    @Override
    public void setMouseManager(MouseManager manager) {
        this.getMouseMediator().setMouseManager(manager);
        for (AbstractDrawableObject drawable : this.items) {
            if (!(drawable instanceof MouseEventDrawableSource)) continue;
            ((MouseEventDrawableSource)((Object)drawable)).setMouseManager(manager);
        }
    }

    private MouseManager getMouseManager() {
        return this.getMouseMediator().getMouseManager();
    }

    @Override
    public boolean containsInternal(Position position) {
        for (AbstractDrawableObject drawable : this.items) {
            Position pos;
            if (!(drawable instanceof MouseEventDrawableSource) || !(drawable instanceof AbstractDrawableObject) || !((MouseEventDrawableSource)((Object)drawable)).containsInternal(pos = drawable.externalToInternalCoordinates(position))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMouseChangedListener(MouseChangedListener listener) {
        this.getMouseMediator().addMouseChangedListener(listener);
    }

    @Override
    public void removeMouseChangedListener(MouseChangedListener listener) {
        this.getMouseMediator().removeMouseChangedListener(listener);
    }

    @Override
    public String toString() {
        String res = "[";
        for (AbstractDrawableObject drawable : this.items) {
            res = res + drawable.toString();
            res = res + ", ";
        }
        res = res.replaceAll(", $", "");
        res = res + "]";
        return res;
    }
}

