/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.draw.drawable;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.UIManager;
import net.useobjects.draw.drawable.AbstractSingleColorView;
import net.useobjects.draw.drawable.GroupView;
import net.useobjects.sync.SyncGui;

public final class TextView
extends AbstractSingleColorView {
    private Font font;
    private String text;

    public TextView(GroupView parent, String text, double positionX, double positionY) {
        this(parent, text, positionX, positionY, 0.0);
    }

    public TextView(GroupView parent, String text, double positionX, double positionY, double angle) {
        this(parent, text, positionX, positionY, angle, UIManager.getDefaults().getFont("TextArea.font"));
    }

    public TextView(GroupView parent, String text, double positionX, double positionY, double angle, Font font) {
        this(parent, text, positionX, positionY, angle, Color.BLACK, font);
    }

    public TextView(GroupView parent, String text, double positionX, double positionY, double angle, Color color) {
        this(parent, text, positionX, positionY, angle, color, UIManager.getDefaults().getFont("TextArea.font"));
    }

    private TextView(GroupView parent, String text, double positionX, double positionY, double angle, Color color, Font font) {
        super(positionX, positionY, angle, color);
        this.text = text;
        this.font = font.deriveFont(font.getStyle());
        this.setParent(parent);
    }

    public TextView(String text, double positionX, double positionY, double angle, Color color, Font font) {
        this(null, text, positionX, positionY, angle, color, font);
    }

    public TextView(String text, double positionX, double positionY, double angle, Color color) {
        this(null, text, positionX, positionY, angle, color, UIManager.getDefaults().getFont("TextArea.font"));
    }

    public void setText(final String newText) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                TextView.this.text = newText;
                TextView.this.fireChanged();
            }
        });
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void draw(Graphics2D g2d) {
        super.draw(g2d);
        g2d.setFont(this.font);
        g2d.drawString(this.text, 0, 0);
    }

    @Override
    public String toString() {
        return super.toString() + ", font=" + this.font + ", text=\"" + this.text + "\"";
    }
}

