/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.geom;

public class Size {
    private double width;
    private double height;

    public Size(Size size) {
        this(size.getWidth(), size.getHeight());
    }

    public Size(double width, double height) {
        this.set(width, height);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Size other = (Size)obj;
        if (Double.doubleToLongBits(this.width) != Double.doubleToLongBits(other.width)) {
            return false;
        }
        return Double.doubleToLongBits(this.height) == Double.doubleToLongBits(other.height);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.width) ^ Double.doubleToLongBits(this.width) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.height) ^ Double.doubleToLongBits(this.height) >>> 32);
        return hash;
    }

    public Size set(double width, double height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public Size setWidth(double width) {
        this.width = width;
        return this;
    }

    public Size setHeight(double height) {
        this.height = height;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public int getRoundedWidth() {
        return (int)Math.round(this.width);
    }

    public int getRoundedHeight() {
        return (int)Math.round(this.height);
    }

    public Size add(double addedWidth, double addedHeight) {
        this.width += addedWidth;
        this.height += addedHeight;
        return this;
    }

    public Size addWidth(double addedWidth) {
        this.width += addedWidth;
        return this;
    }

    public Size addHeight(double addedHeight) {
        this.height += addedHeight;
        return this;
    }

    public Size multiply(double mulWidth, double mulHeight) {
        this.width *= mulWidth;
        this.height *= mulHeight;
        return this;
    }

    public Size multiplyWidth(double mulWidth) {
        this.width *= mulWidth;
        return this;
    }

    public Size multiplyHeight(double mulHeight) {
        this.height *= mulHeight;
        return this;
    }

    public String toString() {
        return "(" + this.width + "x" + this.height + ")";
    }
}

