/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.useobjects.MainFrameAttributeMousePositionLabel;
import net.useobjects.MainFrameAttributeSizeLabel;
import net.useobjects.SyncGui;
import net.useobjects.Window2D;
import net.useobjects.World;

class MainFrame {
    private JFrame frame;
    private Window2D window;

    public MainFrame(World world, String title) {
        this(world, title, 0, 0);
    }

    public MainFrame(final World world, final String title, final int width, final int height) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.frame = new JFrame(title);
                MainFrame.this.frame.setDefaultCloseOperation(3);
                MainFrame.this.frame.setResizable(false);
                MainFrame.this.window = new Window2D(world, width, height);
                MainFrame.this.frame.setLayout(new BorderLayout());
                MainFrame.this.frame.add((Component)MainFrame.this.window, "Center");
                JPanel statusPanel = new JPanel(new FlowLayout(0, 0, 0));
                MainFrame.this.frame.add((Component)statusPanel, "South");
                MainFrameAttributeSizeLabel sizeLabel = new MainFrameAttributeSizeLabel("size");
                MainFrame.this.window.addComponentListener(sizeLabel);
                statusPanel.add(sizeLabel);
                MainFrameAttributeMousePositionLabel positionLabel = new MainFrameAttributeMousePositionLabel("position");
                MainFrame.this.window.addMouseListener(positionLabel);
                MainFrame.this.window.addMouseMotionListener(positionLabel);
                statusPanel.add(positionLabel);
                MainFrame.this.frame.pack();
                MainFrame.this.frame.setVisible(true);
            }
        });
    }

    public void setVisible(final boolean b) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.frame.setVisible(b);
            }
        });
    }

    public Window2D getWindow2D() {
        return this.window;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void dispose() {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.frame.dispose();
            }
        });
    }

    private class InnerWindowListener
    implements WindowListener {
        private InnerWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            System.out.println("windowOpened");
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.out.println("windowClosing " + MainFrame.this.frame.getTitle());
            MainFrame.this.dispose();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            System.out.println("windowClosed " + MainFrame.this.frame.getTitle());
        }

        @Override
        public void windowIconified(WindowEvent e) {
            System.out.println("windowIconified");
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            System.out.println("windowDeiconified");
        }

        @Override
        public void windowActivated(WindowEvent e) {
            System.out.println("windowActivated");
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            System.out.println("windowDeactivated");
        }
    }
}

