/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Graphics2D;
import net.useobjects.AbstractDrawableObject;
import net.useobjects.SyncGui;
import net.useobjects.geom.Position;
import net.useobjects.geom.Vector;

abstract class AbstractDrawableMovableObject
extends AbstractDrawableObject {
    private Position position;

    public AbstractDrawableMovableObject(double positionX, double positionY) {
        this.position = new Position(positionX, positionY);
    }

    public AbstractDrawableMovableObject(Position position) {
        this(position.getX(), position.getY());
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        g2d.translate(this.getPositionX(), this.getPositionY());
    }

    protected void setPosition(final double x, final double y) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractDrawableMovableObject.this.position.set(x, y);
                AbstractDrawableMovableObject.this.fireChanged();
            }
        });
    }

    protected void setPosition(Position position) {
        this.setPosition(position.getX(), position.getY());
    }

    protected void setPositionX(double x) {
        this.setPosition(x, this.getPositionY());
    }

    protected void setPositionY(double y) {
        this.setPosition(this.getPositionX(), y);
    }

    protected Position getPosition() {
        return new Position(this.position);
    }

    protected double getPositionX() {
        return this.position.getX();
    }

    protected double getPositionY() {
        return this.position.getY();
    }

    protected int getRoundedPositionX() {
        return this.position.getRoundedX();
    }

    protected int getRoundedPositionY() {
        return this.position.getRoundedY();
    }

    protected void move(double offsetX, double offsetY) {
        this.setPosition(this.position.getX() + offsetX, this.position.getY() + offsetY);
    }

    protected void move(Vector offset) {
        this.move(offset.getX(), offset.getY());
    }

    protected void moveTowards(double length, Position towards) {
        Position position = this.getPosition();
        position.moveTowards(length, towards);
        this.setPosition(position);
    }

    protected void moveInDirection(double length, double angle) {
        Position position = this.getPosition();
        position.moveInDirection(length, angle);
        this.setPosition(position);
    }

    @Override
    Position externalToInternalCoordinates(Position externalPosition) {
        Position internal = super.externalToInternalCoordinates(externalPosition);
        internal.add(-this.getPositionX(), -this.getPositionY());
        return internal;
    }

    @Override
    Position internalToExternalCoordinates(Position internalPosition) {
        Position external = new Position(internalPosition);
        external.add(this.getPositionX(), this.getPositionY());
        return external;
    }

    Position getPositionInRootGroup() {
        return this.internalToGlobalCoordinates(new Position(0.0, 0.0));
    }

    public String toString() {
        return "position=" + this.position;
    }
}

