/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.geom;

public class Range {
    private double min;
    private double max;

    public Range(double min, double max) {
        assert (min < max);
        this.min = min;
        this.max = max;
    }

    public Range(Range range) {
        this(range.min, range.max);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (Double.doubleToLongBits(this.min) != Double.doubleToLongBits(other.min)) {
            return false;
        }
        return Double.doubleToLongBits(this.max) == Double.doubleToLongBits(other.max);
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + (int)(Double.doubleToLongBits(this.min) ^ Double.doubleToLongBits(this.min) >>> 32);
        hash = 43 * hash + (int)(Double.doubleToLongBits(this.max) ^ Double.doubleToLongBits(this.max) >>> 32);
        return hash;
    }

    public Range setMin(double min) {
        this.min = min;
        return this;
    }

    public Range setMax(double max) {
        this.max = max;
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Range set(double min, double max) {
        this.min = min;
        this.max = max;
        return this;
    }

    @Deprecated
    public double length() {
        return this.getLength();
    }

    public double getLength() {
        return this.max - this.min;
    }

    public boolean contains(double value) {
        return value >= this.min && value < this.max;
    }

    public double toRange(double value) {
        return Range.toRange(this.min, this.max, value);
    }

    public static double toRange(double min, double max, double value) {
        assert (min < max);
        if (value < min) {
            value = min;
        }
        if (value >= max) {
            value = Math.nextAfter(max, Double.NEGATIVE_INFINITY);
        }
        return value;
    }

    public double createRandom() {
        return this.min + Math.random() * this.length();
    }

    @Deprecated
    public double random() {
        return this.createRandom();
    }

    public static double createRandom(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Deprecated
    public static double random(double min, double max) {
        return Range.createRandom(min, max);
    }

    public String toString() {
        return "<" + this.min + ", " + this.max + ')';
    }
}

