/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.geom;

import net.useobjects.geom.Vector;

public class Position
implements Cloneable {
    private double x;
    private double y;

    public Position(Position position) {
        this(position.getX(), position.getY());
    }

    public Position(double x, double y) {
        this.set(x, y);
    }

    public Position set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Position set(Position position) {
        this.x = position.x;
        this.y = position.y;
        return this;
    }

    public Position setX(double x) {
        this.x = x;
        return this;
    }

    public Position setY(double y) {
        this.y = y;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getRoundedX() {
        return (int)Math.round(this.x);
    }

    public int getRoundedY() {
        return (int)Math.round(this.y);
    }

    public Position add(double addToX, double addToY) {
        this.x += addToX;
        this.y += addToY;
        return this;
    }

    public Position addX(double addToX) {
        this.x += addToX;
        return this;
    }

    public Position addY(double addToY) {
        this.y += addToY;
        return this;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public static double distance(Position p1, Position p2) {
        double diffX = p1.getX() - p2.getX();
        double diffY = p1.getY() - p2.getY();
        return Math.sqrt(diffX * diffX + diffY * diffY);
    }

    public static double angle(Position p1, Position p2) {
        double distance = Position.distance(p1, p2);
        double diffX = p2.getX() - p1.getX();
        double diffY = p2.getY() - p1.getY();
        double angle = Math.asin(diffY / distance);
        if (diffX < 0.0) {
            angle = diffY == 0.0 ? Math.PI : Math.signum(diffY) * Math.PI - angle;
        }
        return angle;
    }

    public Position clone() {
        return new Position(this);
    }

    public Position cloneAndMove(double addX, double addY) {
        return new Position(this.x + addX, this.y + addY);
    }

    public Position cloneAndAdd(Vector vector) {
        return new Position(this.x + vector.getX(), this.y + vector.getY());
    }

    public Position cloneAndSubtract(Vector vector) {
        return new Position(this.x - vector.getX(), this.y - vector.getY());
    }

    public static Position createRandom(int minX, int minY, int maxX, int maxY) {
        int diffX = maxX - minX;
        int diffY = maxY - minY;
        int x = (int)(Math.random() * (double)diffX);
        int y = (int)(Math.random() * (double)diffY);
        return new Position(x + minX, y + minY);
    }

    public Vector toVector() {
        return new Vector(this.x, this.y);
    }

    public boolean isInRectangle(double minX, double minY, double maxX, double maxY) {
        return minX <= this.x && this.x < maxX && minY <= this.y && this.y < maxY;
    }

    public Position moveInDirection(double length, double angle) {
        double diffX = length * Math.cos(angle);
        double diffY = length * Math.sin(angle);
        this.add(diffX, diffY);
        return this;
    }

    public Position moveTowards(double length, Position towards) {
        if (Position.distance(this, towards) <= length) {
            this.set(towards);
        } else {
            this.moveInDirection(length, Position.angle(this, towards));
        }
        return this;
    }

    public Position moveTowards(double length, double towardsX, double towardsY) {
        return this.moveTowards(length, new Position(towardsX, towardsY));
    }
}

