/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.util.LinkedList;
import java.util.List;
import net.useobjects.AbstractDrawableObject;
import net.useobjects.Background;
import net.useobjects.ComponentPropertyEvent;
import net.useobjects.ComponentPropertyListener;
import net.useobjects.Group;
import net.useobjects.Keyboard;
import net.useobjects.KeyboardForGame;
import net.useobjects.MainFrame;
import net.useobjects.MouseManager;
import net.useobjects.SyncGui;
import net.useobjects.keyboard.KeyboardListener;
import net.useobjects.keyboard.Keys;

public class World {
    private static final int MIN_WIDTH = 250;
    private static final int MIN_HEIGHT = 200;
    private Group rootGroup;
    private final int width;
    private final int height;
    private Background canvas;
    private MainFrame mainFrame;
    private List<AbstractDrawableObject> selected;
    private Keyboard keyboard;
    private KeyboardForGame keyboardForGame;
    private MouseManager mouseManager;

    public World(String name) {
        this(name, 0, 0);
    }

    public World(String name, int width, int height) {
        this.width = Math.max(width, 250);
        this.height = Math.max(height, 200);
        this.rootGroup = new Group(null, 0.0, 0.0);
        this.rootGroup.addComponentPropertyListener(new InnerDrawableChangedListener());
        this.selected = new LinkedList<AbstractDrawableObject>();
        this.mainFrame = new MainFrame(this, name, this.width, this.height);
        this.canvas = new Background(this.mainFrame.getWindow2D());
        this.keyboard = new Keyboard(this.mainFrame.getFrame());
        this.keyboardForGame = new KeyboardForGame(this, this.mainFrame.getFrame());
        this.mouseManager = new MouseManager(this.mainFrame.getWindow2D());
        this.rootGroup.setMouseManager(this.mouseManager);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Group getRootGroup() {
        return this.rootGroup;
    }

    public Background getBackground() {
        return this.canvas;
    }

    public boolean isKeyDown(int keyCode) {
        return this.isKeyPressed(keyCode);
    }

    public boolean isKeyPressed(int keyCode) {
        return this.keyboard.isKeyPressed(keyCode);
    }

    public Keys getKeysPressed() {
        return this.keyboard.getKeysPressed();
    }

    public void addKeyboardListener(KeyboardListener listener) {
        this.keyboardForGame.addKeyboardListener(listener);
    }

    public void removeKeyboardListener(KeyboardListener listener) {
        this.keyboardForGame.removeKeyboardListener(listener);
    }

    public void destroy() {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                World.this.mainFrame.dispose();
            }
        });
    }

    MainFrame getMainFrame() {
        return this.mainFrame;
    }

    private class InnerDrawableChangedListener
    implements ComponentPropertyListener {
        private InnerDrawableChangedListener() {
        }

        @Override
        public void onPropertyChanged(ComponentPropertyEvent event) {
            World.this.mainFrame.getWindow2D().repaint();
        }
    }
}

