/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.useobjects.World;
import net.useobjects.keyboard.KeyboardEvent;
import net.useobjects.keyboard.KeyboardListener;

class KeyboardForGame
implements KeyListener,
FocusListener {
    private World world;
    private List<KeyboardListener> listeners;
    private Set<Integer> keyCodes;
    private Timer timer;

    public KeyboardForGame(World world, Component eventSource) {
        this.world = world;
        this.listeners = new ArrayList<KeyboardListener>();
        this.keyCodes = new HashSet<Integer>();
        this.timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardForGame.this.sendKeyPressedEvent();
            }
        });
        this.timer.setInitialDelay(0);
        eventSource.addKeyListener(this);
        eventSource.addFocusListener(this);
    }

    private void sendKeyPressedEvent() {
        if (!this.keyCodes.isEmpty()) {
            for (KeyboardListener listener : this.listeners.toArray(new KeyboardListener[0])) {
                listener.onKeyPressed(new KeyboardEvent(this.world, this.keyCodes));
            }
        }
    }

    private void sendKeyReleasedEvent(int keyCode) {
        for (KeyboardListener listener : this.listeners.toArray(new KeyboardListener[0])) {
            listener.onKeyReleased(new KeyboardEvent(this.world, new int[]{keyCode}));
        }
    }

    public void addKeyboardListener(KeyboardListener listener) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.listeners.add(listener);
        }
    }

    public void removeKeyboardListener(KeyboardListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyCodes.add(e.getKeyCode());
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyCodes.remove(e.getKeyCode());
        if (this.keyCodes.isEmpty()) {
            this.timer.stop();
        }
        this.sendKeyReleasedEvent(e.getKeyCode());
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.timer.stop();
        this.keyCodes.clear();
    }
}

