/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.geom;

public class Range {
    private double min;
    private double max;

    public Range(double min, double max) {
        assert (min < max);
        this.min = min;
        this.max = max;
    }

    public Range(Range range) {
        this(range.min, range.max);
    }

    public Range setMin(double min) {
        this.min = min;
        return this;
    }

    public Range setMax(double max) {
        this.max = max;
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Range set(double min, double max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public double length() {
        return this.getLength();
    }

    public double getLength() {
        return this.max - this.min;
    }

    public boolean contains(double value) {
        return value >= this.min && value < this.max;
    }

    public double toRange(double value) {
        return Range.toRange(this.min, this.max, value);
    }

    public static double toRange(double min, double max, double value) {
        assert (min < max);
        if (value < min) {
            value = min;
        }
        if (value >= max) {
            value = Math.nextAfter(max, Double.NEGATIVE_INFINITY);
        }
        return value;
    }

    public double random() {
        return this.min + Math.random() * this.length();
    }

    public static double random(double min, double max) {
        return min + Math.random() * (max - min);
    }

    public String toString() {
        return "<" + this.min + ", " + this.max + ')';
    }
}

