/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Color;
import java.awt.Graphics2D;
import net.useobjects.AbstractGroup;
import net.useobjects.AbstractSingleColorComponent;
import net.useobjects.SyncGui;
import net.useobjects.SyncRunnableWithResult;
import net.useobjects.geom.Position;

public final class Line
extends AbstractSingleColorComponent {
    private double length;

    public Line(AbstractGroup parent, double centerX, double centerY, double angle, Color color, double length) {
        super(centerX, centerY, angle, color);
        this.length = length;
        this.setParent(parent);
    }

    public Line(double centerX, double centerY, double angle, Color color, double length) {
        this(null, centerX, centerY, angle, color, length);
    }

    public Line(double startX, double startY, double endX, double endY, Color color) {
        this(null, startX, startY, endX, endY, color);
    }

    public Line(AbstractGroup parent, double startX, double startY, double endX, double endY, Color color) {
        this(parent, 0.0, 0.0, 0.0, color, 0.0);
        this.setPosition(startX, startY, endX, endY);
    }

    public Line(AbstractGroup parent, double startX, double startY, double endX, double endY) {
        this(parent, startX, startY, endX, endY, DEFAULT_COLOR);
    }

    public void setPosition(Position start, Position end) {
        this.setPosition(start.getX(), start.getY(), end.getX(), end.getY());
    }

    public void setPosition(double startX, double startY, double endX, double endY) {
        double diffX = endX - startX;
        double diffY = endY - startY;
        super.setPosition(startX + diffX / 2.0, startY + diffY / 2.0);
        Position start = new Position(startX, startY);
        Position end = new Position(endX, endY);
        this.length = Position.distance(start, end);
        this.setRotation(Position.angle(start, end));
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        g2d.drawLine((int)(-this.length / 2.0), 0, (int)(this.length / 2.0), 0);
    }

    public double getLength() {
        return SyncGui.invokeAndWait(new SyncRunnableWithResult<Double>(){

            @Override
            public Double runAndReturnResult() {
                return Line.this.length;
            }
        });
    }

    public Position getStartPosition() {
        return SyncGui.invokeAndWait(new SyncRunnableWithResult<Position>(){

            @Override
            public Position runAndReturnResult() {
                double x = Line.this.getPositionX() - Math.cos(Line.this.getRotation()) * Line.this.length / 2.0;
                double y = Line.this.getPositionY() - Math.sin(Line.this.getRotation()) * Line.this.length / 2.0;
                return new Position(x, y);
            }
        });
    }

    public Position getEndPosition() {
        return SyncGui.invokeAndWait(new SyncRunnableWithResult<Position>(){

            @Override
            public Position runAndReturnResult() {
                double x = Line.this.getPositionX() + Math.cos(Line.this.getRotation()) * Line.this.length / 2.0;
                double y = Line.this.getPositionY() + Math.sin(Line.this.getRotation()) * Line.this.length / 2.0;
                return new Position(x, y);
            }
        });
    }

    public void setStartPosition(final double startX, final double startY) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Line.this.setPosition(startX, startY, Line.this.getEndPosition().getX(), Line.this.getEndPosition().getY());
                Line.this.fireChanged();
            }
        });
    }

    public void setEndPosition(final double endX, final double endY) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Line.this.setPosition(Line.this.getStartPosition().getX(), Line.this.getStartPosition().getY(), endX, endY);
                Line.this.fireChanged();
            }
        });
    }

    public void setStartPosition(Position startPosition) {
        this.setStartPosition(startPosition.getX(), startPosition.getY());
    }

    public void setEndPosition(Position endPosition) {
        this.setEndPosition(endPosition.getX(), endPosition.getY());
    }

    @Override
    public String toString() {
        return super.toString() + ", length=" + this.length;
    }
}

