/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Graphics2D;
import java.awt.Point;
import net.useobjects.AbstractDrawableMovableRotatableObject;
import net.useobjects.SyncGui;
import net.useobjects.geom.Position;

abstract class AbstractDrawableMovableRotatableResizeableObject
extends AbstractDrawableMovableRotatableObject {
    private double resize;

    public AbstractDrawableMovableRotatableResizeableObject(Position position) {
        this(position.getX(), position.getY());
    }

    public AbstractDrawableMovableRotatableResizeableObject(double positionX, double positionY) {
        this(positionX, positionY, 0.0);
    }

    public AbstractDrawableMovableRotatableResizeableObject(Point position, double angle) {
        this(position.getX(), position.getY(), angle);
    }

    public AbstractDrawableMovableRotatableResizeableObject(double positionX, double positionY, double angle) {
        this(positionX, positionY, angle, 1.0);
    }

    public AbstractDrawableMovableRotatableResizeableObject(Position position, double angle, double resizeFactor) {
        this(position.getX(), position.getY(), angle);
        this.resize = resizeFactor;
    }

    public AbstractDrawableMovableRotatableResizeableObject(double positionX, double positionY, double angle, double resizeFactor) {
        super(positionX, positionY, angle);
        this.resize = resizeFactor;
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        g2d.scale(this.getResizeFactor(), this.getResizeFactor());
    }

    protected void setResizeFactor(final double resizeFactor) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractDrawableMovableRotatableResizeableObject.this.resize = resizeFactor;
                AbstractDrawableMovableRotatableResizeableObject.this.fireChanged();
            }
        });
    }

    protected double getResizeFactor() {
        return this.resize;
    }

    @Override
    Position externalToInternalCoordinates(Position externalPosition) {
        Position internal = super.externalToInternalCoordinates(externalPosition);
        double x = internal.getX() / this.getResizeFactor();
        double y = internal.getY() / this.getResizeFactor();
        internal.set(x, y);
        return internal;
    }

    @Override
    Position internalToExternalCoordinates(Position internalPosition) {
        double x = internalPosition.getX() * this.getResizeFactor();
        double y = internalPosition.getY() * this.getResizeFactor();
        Position external = new Position(x, y);
        external = super.internalToExternalCoordinates(internalPosition);
        return external;
    }

    @Override
    public String toString() {
        return super.toString() + ", resize=" + this.resize;
    }
}

