/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Graphics2D;
import net.useobjects.AbstractDrawableMovableObject;
import net.useobjects.SyncGui;
import net.useobjects.geom.Position;

abstract class AbstractDrawableMovableRotatableObject
extends AbstractDrawableMovableObject {
    private double angle;

    public AbstractDrawableMovableRotatableObject(double positionX, double positionY, double angle) {
        super(positionX, positionY);
        this.angle = angle;
    }

    public AbstractDrawableMovableRotatableObject(Position position, double angle) {
        this(position.getX(), position.getY(), angle);
    }

    public AbstractDrawableMovableRotatableObject(double positionX, double positionY) {
        this(positionX, positionY, 0.0);
    }

    public AbstractDrawableMovableRotatableObject(Position position) {
        this(position.getX(), position.getY());
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        g2d.rotate(this.getRotation());
    }

    protected double getRotation() {
        return this.angle;
    }

    protected void setRotation(final double angle) {
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractDrawableMovableRotatableObject.this.angle = angle;
                AbstractDrawableMovableRotatableObject.this.fireChanged();
            }
        });
    }

    protected void rotate(double deltaAngle) {
        this.setRotation(this.getRotation() + deltaAngle);
    }

    protected void moveForwards(double length) {
        Position position = this.getPosition();
        position.moveInDirection(length, this.getRotation());
        this.setPosition(position);
    }

    @Override
    Position externalToInternalCoordinates(Position externalPosition) {
        Position internal = super.externalToInternalCoordinates(externalPosition);
        double theta = -this.getRotation();
        double x = internal.getX();
        double y = internal.getY();
        double xx = x * Math.cos(theta) - y * Math.sin(theta);
        double yy = x * Math.sin(theta) + y * Math.cos(theta);
        internal.set(xx, yy);
        return internal;
    }

    @Override
    Position internalToExternalCoordinates(Position internalPosition) {
        double theta = this.getRotation();
        double x = internalPosition.getX();
        double y = internalPosition.getY();
        double xx = x * Math.cos(theta) - y * Math.sin(theta);
        double yy = x * Math.sin(theta) + y * Math.cos(theta);
        Position external = new Position(xx, yy);
        external = super.internalToExternalCoordinates(external);
        return external;
    }

    @Override
    public String toString() {
        return super.toString() + ", rotation=" + this.angle;
    }
}

