/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.useobjects.MouseEventDataConverter;
import net.useobjects.Window2D;
import net.useobjects.mouse.MouseEvent;
import net.useobjects.mouse.MouseEventSource;
import net.useobjects.mouse.MouseListener;

class MouseEventConventer
implements java.awt.event.MouseListener,
MouseMotionListener,
MouseWheelListener {
    private MouseEventSource newMouseEventSource;
    private List<MouseListener> listeners;

    public MouseEventConventer(Window2D window, MouseEventSource newMouseEventSource) {
        this.newMouseEventSource = newMouseEventSource;
        this.listeners = new ArrayList<MouseListener>();
        window.addMouseListener(this);
        window.addMouseMotionListener(this);
        window.addMouseWheelListener(this);
    }

    public void addMouseChangedListener(MouseListener listener) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.listeners.add(listener);
        }
    }

    public void removeMouseChangedListener(MouseListener listener) {
        this.listeners.remove(listener);
    }

    private MouseEvent createMouseChangedEvent(MouseEventSource newSource, java.awt.event.MouseEvent event) {
        return new MouseEvent(newSource, MouseEventDataConverter.convertStandardMouseEventType(event.getID()), event.getX(), event.getY(), event.getXOnScreen(), event.getYOnScreen(), MouseEventDataConverter.convertStandardButtonCode(event.getButton()), 0, event.getWhen());
    }

    private MouseEvent createMouseChangedEvent(MouseEventSource newSource, MouseWheelEvent event) {
        return new MouseEvent(newSource, MouseEventDataConverter.convertStandardMouseEventType(event.getID()), event.getX(), event.getY(), event.getXOnScreen(), event.getYOnScreen(), MouseEventDataConverter.convertStandardButtonCode(event.getButton()), event.getWheelRotation(), event.getWhen());
    }

    @Override
    public void mouseClicked(java.awt.event.MouseEvent e) {
        MouseEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseListener listener : this.listeners.toArray(new MouseListener[0])) {
            listener.onMouseClicked(newEvent);
        }
    }

    @Override
    public void mousePressed(java.awt.event.MouseEvent e) {
        MouseEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseListener listener : this.listeners.toArray(new MouseListener[0])) {
            listener.onMousePressed(newEvent);
        }
    }

    @Override
    public void mouseReleased(java.awt.event.MouseEvent e) {
        MouseEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseListener listener : this.listeners.toArray(new MouseListener[0])) {
            listener.onMouseReleased(newEvent);
        }
    }

    @Override
    public void mouseEntered(java.awt.event.MouseEvent e) {
        MouseEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseListener listener : this.listeners.toArray(new MouseListener[0])) {
            listener.onMouseEntered(newEvent);
        }
    }

    @Override
    public void mouseExited(java.awt.event.MouseEvent e) {
        MouseEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseListener listener : this.listeners.toArray(new MouseListener[0])) {
            listener.onMouseExited(newEvent);
        }
    }

    @Override
    public void mouseDragged(java.awt.event.MouseEvent e) {
        MouseEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseListener listener : this.listeners.toArray(new MouseListener[0])) {
            listener.onMouseDragged(newEvent);
        }
    }

    @Override
    public void mouseMoved(java.awt.event.MouseEvent e) {
        MouseEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseListener listener : this.listeners.toArray(new MouseListener[0])) {
            listener.onMouseMoved(newEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        MouseEvent newEvent = this.createMouseChangedEvent(this.newMouseEventSource, e);
        for (MouseListener listener : this.listeners.toArray(new MouseListener[0])) {
            listener.onMouseWheelMoved(newEvent);
        }
    }
}

