/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.timer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.useobjects.timer.TimerEvent;
import net.useobjects.timer.TimerListener;

public class EventLoopTimer {
    private Timer timer;
    private List<TimerListener> listeners = new ArrayList<TimerListener>();

    public EventLoopTimer(int initDelay, int delay, boolean repeate, TimerListener listener) {
        if (listener != null) {
            this.addTimerListener(listener);
        }
        this.timer = new Timer(delay, new TimerShooter());
        this.timer.setInitialDelay(initDelay);
        this.timer.setRepeats(repeate);
    }

    public EventLoopTimer(int initDelay, int delay, TimerListener listener) {
        this(initDelay, delay, true, listener);
    }

    public EventLoopTimer(int delay, TimerListener listener) {
        this(delay, delay, listener);
    }

    public EventLoopTimer(int initDelay, int delay, boolean repeate) {
        this(initDelay, delay, repeate, null);
    }

    public EventLoopTimer(int delay) {
        this(delay, delay, true, null);
    }

    public void addTimerListener(TimerListener listener) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.listeners.add(listener);
        }
    }

    public void removeTimerListener(TimerListener listener) {
        this.listeners.remove(listener);
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public void setInitialDelay(int initialDelay) {
        this.timer.setInitialDelay(initialDelay);
    }

    public int getInitialDelay() {
        return this.timer.getInitialDelay();
    }

    public void setRepeats(boolean flag) {
        this.timer.setRepeats(flag);
    }

    public boolean isRepeats() {
        return this.timer.isRepeats();
    }

    public void setCoalesce(boolean flag) {
        this.timer.setCoalesce(flag);
    }

    public boolean isCoalesce() {
        return this.timer.isCoalesce();
    }

    public void start() {
        this.timer.start();
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public void stop() {
        this.timer.stop();
    }

    public void restart() {
        this.timer.restart();
    }

    public String toString() {
        return "(initDelay=" + this.timer.getInitialDelay() + ",delay=" + this.timer.getDelay() + ",isRunning=" + this.timer.isRunning() + ",isRepeats=" + this.timer.isRepeats() + ",isCoalesce=" + this.timer.isCoalesce() + ",count of listeners=" + this.timer.getActionListeners().length + ")";
    }

    private class TimerShooter
    implements ActionListener {
        private TimerShooter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TimerEvent timerEvent = new TimerEvent(EventLoopTimer.this);
            for (TimerListener listener : EventLoopTimer.this.listeners.toArray(new TimerListener[0])) {
                listener.onTimerEvent(timerEvent);
            }
        }
    }
}

