/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.keyboard;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.useobjects.World;
import net.useobjects.keyboard.Keys;

public class KeyboardEvent {
    private World source;
    private int[] keyCodes;

    public KeyboardEvent(World world, Set<Integer> keyCodeSet) {
        this(world, KeyboardEvent.setToArray(keyCodeSet));
    }

    public KeyboardEvent(World world, int[] keyCodes) {
        this.source = this.source;
        this.keyCodes = Arrays.copyOf(keyCodes, keyCodes.length);
    }

    public World getSource() {
        return this.source;
    }

    private static int[] setToArray(Set<Integer> keyCodeSet) {
        int[] array = new int[keyCodeSet.size()];
        int index = 0;
        for (Integer key : keyCodeSet) {
            array[index] = key;
            ++index;
        }
        return array;
    }

    private static Set<Integer> arrayToSet(int[] keyCodeArray) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : keyCodeArray) {
            set.add(i);
        }
        return set;
    }

    public Keys getKeys() {
        return new Keys(KeyboardEvent.arrayToSet(this.keyCodes));
    }

    public int[] getKeyCodes() {
        return Arrays.copyOf(this.keyCodes, this.keyCodes.length);
    }

    public boolean contains(int keyCode) {
        for (int key : this.keyCodes) {
            if (key != keyCode) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.getKeyCodes());
    }
}

