/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects.geom;

import net.useobjects.geom.Position;

public class Vector {
    private double x;
    private double y;

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector(Position start, Position end) {
        this.x = end.getX() - start.getX();
        this.y = end.getY() - start.getY();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double getOrientation() {
        return Position.angle(new Position(0.0, 0.0), new Position(this.x, this.y));
    }

    public static double getAngle(Vector vector1, Vector vector2) {
        return Vector.dotProduct(vector1, vector2) / vector1.getLength() / vector2.getLength();
    }

    public static double dotProduct(Vector vector1, Vector vector2) {
        return vector1.x * vector2.x + vector1.y * vector2.y;
    }

    public Position toPosition() {
        return new Position(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ')';
    }
}

