/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.useobjects.AbstractDrawableObject;
import net.useobjects.MouseEventDataConverter;
import net.useobjects.MouseEventDrawableSource;
import net.useobjects.MouseManager;
import net.useobjects.geom.Position;
import net.useobjects.mouse.MouseEvent;
import net.useobjects.mouse.MouseListener;

class MouseMediator {
    private MouseEventDrawableSource view;
    private MouseManager manager;
    private List<MouseListener> mouseChangedListenerList;
    private boolean mouseInside;
    private List<Integer> pressedButtons;
    private boolean ownMouse;

    public MouseMediator(MouseEventDrawableSource view) {
        this.view = view;
        this.mouseChangedListenerList = new ArrayList<MouseListener>();
        this.pressedButtons = new ArrayList<Integer>();
        this.ownMouse = false;
    }

    public void setMouseManager(MouseManager manager) {
        if (this.manager != manager) {
            if (this.manager != null) {
                this.manager.removeMouseMediator(this);
            }
            this.manager = manager;
            if (this.manager != null && !this.mouseChangedListenerList.isEmpty()) {
                manager.addMouseMediator(this);
                this.mouseInside = this.IsMouseInside();
                this.pressedButtons.clear();
            }
        }
    }

    public MouseManager getMouseManager() {
        return this.manager;
    }

    public void addMouseChangedListener(MouseListener listener) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        this.mouseChangedListenerList.add(listener);
        if (this.manager != null && !this.manager.containMouseMediator(this)) {
            this.manager.addMouseMediator(this);
            this.mouseInside = this.IsMouseInside();
            this.pressedButtons.clear();
        }
    }

    public void removeMouseChangedListener(MouseListener listener) {
        this.mouseChangedListenerList.remove(listener);
        if (this.mouseChangedListenerList.isEmpty() && this.manager != null) {
            this.manager.removeMouseMediator(this);
        }
    }

    private boolean IsMouseInside() {
        Point mousePosition = this.manager.getWindow().getMousePosition();
        if (mousePosition == null) {
            return false;
        }
        return this.isInInternal(mousePosition.x, mousePosition.y);
    }

    private Position globalToInternal(int x, int y) {
        return ((AbstractDrawableObject)((Object)this.view)).globalToInternalCoordinates(new Position(x, y));
    }

    private boolean isInInternal(int x, int y) {
        Position internal = this.globalToInternal(x, y);
        return this.view.containsInternal(internal);
    }

    private MouseEvent createInternalMouseEvent(java.awt.event.MouseEvent original, int x, int y) {
        return new MouseEvent(this.view, MouseEventDataConverter.convertStandardMouseEventType(original.getID()), x, y, original.getXOnScreen(), original.getYOnScreen(), MouseEventDataConverter.convertStandardButtonCode(original.getButton()), 0, original.getWhen());
    }

    private java.awt.event.MouseEvent createMouseEventAndChangeType(java.awt.event.MouseEvent original, int type) {
        return new java.awt.event.MouseEvent(original.getComponent(), type, original.getWhen(), original.getModifiersEx(), original.getX(), original.getY(), original.getXOnScreen(), original.getYOnScreen(), original.getClickCount(), original.isPopupTrigger(), original.getButton());
    }

    private MouseEvent createInternalMouseWhellEvent(MouseWheelEvent original, int x, int y) {
        return new MouseEvent(this.view, MouseEventDataConverter.convertStandardMouseEventType(original.getID()), x, y, original.getXOnScreen(), original.getYOnScreen(), MouseEventDataConverter.convertStandardButtonCode(original.getButton()), original.getWheelRotation(), original.getWhen());
    }

    private MouseEvent check(java.awt.event.MouseEvent mouseEvent) {
        Position internalPosition = this.globalToInternal(mouseEvent.getX(), mouseEvent.getY());
        if (this.view.containsInternal(internalPosition)) {
            return this.createInternalMouseEvent(mouseEvent, internalPosition.getRoundedX(), internalPosition.getRoundedY());
        }
        return null;
    }

    private void fire(List<MouseListener> list, java.awt.event.MouseEvent e, Firing<MouseListener> f) {
        MouseEvent newEvent;
        if (!list.isEmpty() && (newEvent = this.check(e)) != null) {
            for (MouseListener listener : list.toArray(new MouseListener[0])) {
                f.execute(listener, newEvent);
            }
        }
    }

    void fireMouseClicked(java.awt.event.MouseEvent e) {
        this.fire(this.mouseChangedListenerList, e, new Firing<MouseListener>(){

            @Override
            public void execute(MouseListener listener, MouseEvent newEvent) {
                listener.onMouseClicked(newEvent);
            }
        });
    }

    void fireMousePressed(java.awt.event.MouseEvent e) {
        Position internalPosition;
        if (!(this.mouseChangedListenerList.isEmpty() || !this.view.containsInternal(internalPosition = this.globalToInternal(e.getX(), e.getY())) && this.pressedButtons.isEmpty())) {
            this.pressedButtons.add(e.getButton());
            MouseEvent newEvent = this.createInternalMouseEvent(e, internalPosition.getRoundedX(), internalPosition.getRoundedY());
            for (MouseListener listener : this.mouseChangedListenerList.toArray(new MouseListener[0])) {
                listener.onMousePressed(newEvent);
            }
        }
    }

    void fireMouseReleased(java.awt.event.MouseEvent e) {
        if (!this.mouseChangedListenerList.isEmpty() && this.pressedButtons.contains(e.getButton())) {
            this.pressedButtons.remove((Object)e.getButton());
            Position internalPosition = this.globalToInternal(e.getX(), e.getY());
            MouseEvent newEvent = this.createInternalMouseEvent(e, internalPosition.getRoundedX(), internalPosition.getRoundedY());
            for (MouseListener listener : this.mouseChangedListenerList.toArray(new MouseListener[0])) {
                listener.onMouseReleased(newEvent);
            }
        }
    }

    private void fireMouseEntered(java.awt.event.MouseEvent e) {
        this.fire(this.mouseChangedListenerList, e, new Firing<MouseListener>(){

            @Override
            public void execute(MouseListener listener, MouseEvent newEvent) {
                listener.onMouseEntered(newEvent);
            }
        });
    }

    private void fireMouseExited(java.awt.event.MouseEvent e) {
        if (!this.mouseChangedListenerList.isEmpty()) {
            Position internal = this.globalToInternal(e.getX(), e.getY());
            MouseEvent newEvent = this.createInternalMouseEvent(e, internal.getRoundedX(), internal.getRoundedY());
            for (MouseListener listener : this.mouseChangedListenerList.toArray(new MouseListener[0])) {
                listener.onMouseExited(newEvent);
            }
        }
    }

    void fireEnteredExited(java.awt.event.MouseEvent e) {
        boolean isIn = this.isInInternal(e.getX(), e.getY());
        if (e.getID() == 505) {
            isIn = false;
        }
        if (this.mouseInside != isIn) {
            if (isIn) {
                this.fireMouseEntered(this.createMouseEventAndChangeType(e, 504));
            } else {
                this.fireMouseExited(this.createMouseEventAndChangeType(e, 505));
            }
            this.mouseInside = isIn;
        }
    }

    void fireMouseDragged(java.awt.event.MouseEvent e) {
        if (!this.mouseChangedListenerList.isEmpty()) {
            Position internalPosition = this.globalToInternal(e.getX(), e.getY());
            MouseEvent newEvent = this.createInternalMouseEvent(e, internalPosition.getRoundedX(), internalPosition.getRoundedY());
            if (!this.pressedButtons.isEmpty()) {
                for (MouseListener listener : this.mouseChangedListenerList.toArray(new MouseListener[0])) {
                    listener.onMouseDragged(newEvent);
                }
            }
        }
    }

    void fireMouseMoved(java.awt.event.MouseEvent e) {
        this.fire(this.mouseChangedListenerList, e, new Firing<MouseListener>(){

            @Override
            public void execute(MouseListener listener, MouseEvent newEvent) {
                listener.onMouseMoved(newEvent);
            }
        });
    }

    void fireMouseWheelMoved(MouseWheelEvent e) {
        if (!this.mouseChangedListenerList.isEmpty()) {
            MouseEvent newEvent = this.check(e);
            Position internal = this.globalToInternal(e.getX(), e.getY());
            if (this.view.containsInternal(internal)) {
                newEvent = this.createInternalMouseWhellEvent(e, internal.getRoundedX(), internal.getRoundedY());
                for (MouseListener item : this.mouseChangedListenerList.toArray(new MouseListener[0])) {
                    item.onMouseWheelMoved(newEvent);
                }
            }
        }
    }

    private static interface Firing<T> {
        public void execute(T var1, MouseEvent var2);
    }
}

