/*
 * Decompiled with CFR 0.152.
 */
package net.useobjects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import net.useobjects.AbstractGroup;
import net.useobjects.AbstractSingleColorComponent;
import net.useobjects.AbstractSingleColorFillComponent;
import net.useobjects.SyncGui;
import net.useobjects.geom.Position;

public final class Ellipse
extends AbstractSingleColorFillComponent {
    private double radiusX;
    private double radiusY;

    public Ellipse(AbstractGroup parent, double centerX, double centerY, double radiusX, double radiusY, double angle, Color color, boolean fill) {
        super(centerX, centerY, angle, color, fill);
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.setParent(parent);
    }

    public Ellipse(double centerX, double centerY, double radiusX, double radiusY, double angle, Color color, boolean fill) {
        this(null, centerX, centerY, radiusX, radiusY, angle, color, fill);
    }

    public Ellipse(AbstractGroup parent, double centerX, double centerY, double radiusX, double radiusY, double angle, Color color) {
        this(parent, centerX, centerY, radiusX, radiusY, angle, color, true);
    }

    public Ellipse(AbstractGroup parent, double centerX, double centerY, double radiusX, double radiusY) {
        this(parent, centerX, centerY, radiusX, radiusY, 0.0, AbstractSingleColorComponent.DEFAULT_COLOR);
    }

    @Override
    void drawImpl(Graphics2D g2d) {
        super.drawImpl(g2d);
        if (this.isFilled()) {
            g2d.fill(this.getEllipse());
        } else {
            g2d.draw(this.getEllipse());
        }
    }

    private Ellipse2D.Double getEllipse() {
        return new Ellipse2D.Double(-this.radiusX, -this.radiusY, 2.0 * this.radiusX, 2.0 * this.radiusY);
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public void setRadiusX(final double newRadiusX) {
        this.throwIfNegative(newRadiusX, "zaporny polomer v smere osi x");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Ellipse.this.radiusX = newRadiusX;
                Ellipse.this.fireChanged();
            }
        });
    }

    public void setRadiusY(final double newRadiusY) {
        this.throwIfNegative(newRadiusY, "zaporny polomer v smere osi y");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Ellipse.this.radiusY = newRadiusY;
                Ellipse.this.fireChanged();
            }
        });
    }

    public void setRadiuses(final double newRadiusX, final double newRadiusY) {
        this.throwIfNegative(newRadiusX, "zaporny polomer v smere osi x");
        this.throwIfNegative(newRadiusY, "zaporny polomer v smere osi y");
        SyncGui.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Ellipse.this.radiusX = newRadiusX;
                Ellipse.this.radiusY = newRadiusY;
                Ellipse.this.fireChanged();
            }
        });
    }

    @Override
    public boolean containsInternal(Position internalPosition) {
        double x = internalPosition.getX();
        double y = internalPosition.getY();
        double x2 = x * x;
        double y2 = y * y;
        double rx2 = this.radiusX * this.radiusX;
        double ry2 = this.radiusY * this.radiusY;
        if (rx2 == 0.0 || ry2 == 0.0) {
            return false;
        }
        return x2 / rx2 + y2 / ry2 <= 1.0;
    }

    @Override
    public String toString() {
        return super.toString() + ", radiusX=" + this.radiusX + ", radiusY=" + this.radiusY;
    }
}

